package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Contains PowerShell script properties to detect a Win32 App”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "enforceSignatureCheck", 
    "runAs32Bit", 
    "scriptContent"})
@JsonInclude(Include.NON_NULL)
public class Win32LobAppPowerShellScriptDetection extends Win32LobAppDetection implements ODataType {

    @JsonProperty("enforceSignatureCheck")
    protected Boolean enforceSignatureCheck;

    @JsonProperty("runAs32Bit")
    protected Boolean runAs32Bit;

    @JsonProperty("scriptContent")
    protected String scriptContent;

    protected Win32LobAppPowerShellScriptDetection() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.win32LobAppPowerShellScriptDetection";
    }

    /**
     * <i>“A value indicating whether signature check is enforced”</i>
     * 
     * @return property enforceSignatureCheck
     */
    @Property(name="enforceSignatureCheck")
    @JsonIgnore
    public Optional<Boolean> getEnforceSignatureCheck() {
        return Optional.ofNullable(enforceSignatureCheck);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enforceSignatureCheck} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“A value indicating whether signature check is enforced”</i>
     * 
     * @param enforceSignatureCheck
     *            new value of {@code enforceSignatureCheck} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enforceSignatureCheck} field changed
     */
    public Win32LobAppPowerShellScriptDetection withEnforceSignatureCheck(Boolean enforceSignatureCheck) {
        Win32LobAppPowerShellScriptDetection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppPowerShellScriptDetection");
        _x.enforceSignatureCheck = enforceSignatureCheck;
        return _x;
    }

    /**
     * <i>“A value indicating whether this script should run as 32-bit”</i>
     * 
     * @return property runAs32Bit
     */
    @Property(name="runAs32Bit")
    @JsonIgnore
    public Optional<Boolean> getRunAs32Bit() {
        return Optional.ofNullable(runAs32Bit);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code runAs32Bit} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“A value indicating whether this script should run as 32-bit”</i>
     * 
     * @param runAs32Bit
     *            new value of {@code runAs32Bit} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code runAs32Bit} field changed
     */
    public Win32LobAppPowerShellScriptDetection withRunAs32Bit(Boolean runAs32Bit) {
        Win32LobAppPowerShellScriptDetection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppPowerShellScriptDetection");
        _x.runAs32Bit = runAs32Bit;
        return _x;
    }

    /**
     * <i>“The base64 encoded script content to detect Win32 Line of Business (LoB) app”</i>
     * 
     * @return property scriptContent
     */
    @Property(name="scriptContent")
    @JsonIgnore
    public Optional<String> getScriptContent() {
        return Optional.ofNullable(scriptContent);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code scriptContent}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The base64 encoded script content to detect Win32 Line of Business (LoB) app”</i>
     * 
     * @param scriptContent
     *            new value of {@code scriptContent} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code scriptContent} field changed
     */
    public Win32LobAppPowerShellScriptDetection withScriptContent(String scriptContent) {
        Win32LobAppPowerShellScriptDetection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppPowerShellScriptDetection");
        _x.scriptContent = scriptContent;
        return _x;
    }

    public Win32LobAppPowerShellScriptDetection withUnmappedField(String name, Object value) {
        Win32LobAppPowerShellScriptDetection _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWin32LobAppPowerShellScriptDetection() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean enforceSignatureCheck;
        private Boolean runAs32Bit;
        private String scriptContent;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“A value indicating whether signature check is enforced”</i>
         * 
         * @param enforceSignatureCheck
         *            value of {@code enforceSignatureCheck} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enforceSignatureCheck(Boolean enforceSignatureCheck) {
            this.enforceSignatureCheck = enforceSignatureCheck;
            this.changedFields = changedFields.add("enforceSignatureCheck");
            return this;
        }

        /**
         * <i>“A value indicating whether this script should run as 32-bit”</i>
         * 
         * @param runAs32Bit
         *            value of {@code runAs32Bit} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder runAs32Bit(Boolean runAs32Bit) {
            this.runAs32Bit = runAs32Bit;
            this.changedFields = changedFields.add("runAs32Bit");
            return this;
        }

        /**
         * <i>“The base64 encoded script content to detect Win32 Line of Business (LoB) app”</i>
         * 
         * @param scriptContent
         *            value of {@code scriptContent} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder scriptContent(String scriptContent) {
            this.scriptContent = scriptContent;
            this.changedFields = changedFields.add("scriptContent");
            return this;
        }

        public Win32LobAppPowerShellScriptDetection build() {
            Win32LobAppPowerShellScriptDetection _x = new Win32LobAppPowerShellScriptDetection();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.win32LobAppPowerShellScriptDetection";
            _x.enforceSignatureCheck = enforceSignatureCheck;
            _x.runAs32Bit = runAs32Bit;
            _x.scriptContent = scriptContent;
            return _x;
        }
    }

    private Win32LobAppPowerShellScriptDetection _copy() {
        Win32LobAppPowerShellScriptDetection _x = new Win32LobAppPowerShellScriptDetection();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.enforceSignatureCheck = enforceSignatureCheck;
        _x.runAs32Bit = runAs32Bit;
        _x.scriptContent = scriptContent;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Win32LobAppPowerShellScriptDetection[");
        b.append("enforceSignatureCheck=");
        b.append(this.enforceSignatureCheck);
        b.append(", ");
        b.append("runAs32Bit=");
        b.append(this.runAs32Bit);
        b.append(", ");
        b.append("scriptContent=");
        b.append(this.scriptContent);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
