package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.RunAsAccountType;
import odata.msgraph.client.beta.enums.Win32LobAppRestartBehavior;


/**
 * <i>“Contains installation experience properties for a Win32 App”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deviceRestartBehavior", 
    "runAsAccount"})
@JsonInclude(Include.NON_NULL)
public class Win32LobAppInstallExperience implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("deviceRestartBehavior")
    protected Win32LobAppRestartBehavior deviceRestartBehavior;

    @JsonProperty("runAsAccount")
    protected RunAsAccountType runAsAccount;

    protected Win32LobAppInstallExperience() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.win32LobAppInstallExperience";
    }

    /**
     * <i>“Device restart behavior.”</i>
     * 
     * @return property deviceRestartBehavior
     */
    @Property(name="deviceRestartBehavior")
    @JsonIgnore
    public Optional<Win32LobAppRestartBehavior> getDeviceRestartBehavior() {
        return Optional.ofNullable(deviceRestartBehavior);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceRestartBehavior} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Device restart behavior.”</i>
     * 
     * @param deviceRestartBehavior
     *            new value of {@code deviceRestartBehavior} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceRestartBehavior} field changed
     */
    public Win32LobAppInstallExperience withDeviceRestartBehavior(Win32LobAppRestartBehavior deviceRestartBehavior) {
        Win32LobAppInstallExperience _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppInstallExperience");
        _x.deviceRestartBehavior = deviceRestartBehavior;
        return _x;
    }

    /**
     * <i>“Indicates the type of execution context the app runs in.”</i>
     * 
     * @return property runAsAccount
     */
    @Property(name="runAsAccount")
    @JsonIgnore
    public Optional<RunAsAccountType> getRunAsAccount() {
        return Optional.ofNullable(runAsAccount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code runAsAccount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates the type of execution context the app runs in.”</i>
     * 
     * @param runAsAccount
     *            new value of {@code runAsAccount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code runAsAccount} field changed
     */
    public Win32LobAppInstallExperience withRunAsAccount(RunAsAccountType runAsAccount) {
        Win32LobAppInstallExperience _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppInstallExperience");
        _x.runAsAccount = runAsAccount;
        return _x;
    }

    public Win32LobAppInstallExperience withUnmappedField(String name, Object value) {
        Win32LobAppInstallExperience _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Win32LobAppRestartBehavior deviceRestartBehavior;
        private RunAsAccountType runAsAccount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Device restart behavior.”</i>
         * 
         * @param deviceRestartBehavior
         *            value of {@code deviceRestartBehavior} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceRestartBehavior(Win32LobAppRestartBehavior deviceRestartBehavior) {
            this.deviceRestartBehavior = deviceRestartBehavior;
            this.changedFields = changedFields.add("deviceRestartBehavior");
            return this;
        }

        /**
         * <i>“Indicates the type of execution context the app runs in.”</i>
         * 
         * @param runAsAccount
         *            value of {@code runAsAccount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder runAsAccount(RunAsAccountType runAsAccount) {
            this.runAsAccount = runAsAccount;
            this.changedFields = changedFields.add("runAsAccount");
            return this;
        }

        public Win32LobAppInstallExperience build() {
            Win32LobAppInstallExperience _x = new Win32LobAppInstallExperience();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.win32LobAppInstallExperience";
            _x.deviceRestartBehavior = deviceRestartBehavior;
            _x.runAsAccount = runAsAccount;
            return _x;
        }
    }

    private Win32LobAppInstallExperience _copy() {
        Win32LobAppInstallExperience _x = new Win32LobAppInstallExperience();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.deviceRestartBehavior = deviceRestartBehavior;
        _x.runAsAccount = runAsAccount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Win32LobAppInstallExperience[");
        b.append("deviceRestartBehavior=");
        b.append(this.deviceRestartBehavior);
        b.append(", ");
        b.append("runAsAccount=");
        b.append(this.runAsAccount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
