package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.Win32LobAppDeliveryOptimizationPriority;
import odata.msgraph.client.beta.enums.Win32LobAppNotification;


/**
 * <i>“Contains properties used to assign an Win32 LOB mobile app to a group.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deliveryOptimizationPriority", 
    "installTimeSettings", 
    "notifications", 
    "restartSettings"})
@JsonInclude(Include.NON_NULL)
public class Win32LobAppAssignmentSettings extends MobileAppAssignmentSettings implements ODataType {

    @JsonProperty("deliveryOptimizationPriority")
    protected Win32LobAppDeliveryOptimizationPriority deliveryOptimizationPriority;

    @JsonProperty("installTimeSettings")
    protected MobileAppInstallTimeSettings installTimeSettings;

    @JsonProperty("notifications")
    protected Win32LobAppNotification notifications;

    @JsonProperty("restartSettings")
    protected Win32LobAppRestartSettings restartSettings;

    protected Win32LobAppAssignmentSettings() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.win32LobAppAssignmentSettings";
    }

    /**
     * <i>“The delivery optimization priority for this app assignment. This setting is not
     * supported in National Cloud environments.”</i>
     * 
     * @return property deliveryOptimizationPriority
     */
    @Property(name="deliveryOptimizationPriority")
    @JsonIgnore
    public Optional<Win32LobAppDeliveryOptimizationPriority> getDeliveryOptimizationPriority() {
        return Optional.ofNullable(deliveryOptimizationPriority);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deliveryOptimizationPriority} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The delivery optimization priority for this app assignment. This setting is not
     * supported in National Cloud environments.”</i>
     * 
     * @param deliveryOptimizationPriority
     *            new value of {@code deliveryOptimizationPriority} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deliveryOptimizationPriority} field changed
     */
    public Win32LobAppAssignmentSettings withDeliveryOptimizationPriority(Win32LobAppDeliveryOptimizationPriority deliveryOptimizationPriority) {
        Win32LobAppAssignmentSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppAssignmentSettings");
        _x.deliveryOptimizationPriority = deliveryOptimizationPriority;
        return _x;
    }

    /**
     * <i>“The install time settings to apply for this app assignment.”</i>
     * 
     * @return property installTimeSettings
     */
    @Property(name="installTimeSettings")
    @JsonIgnore
    public Optional<MobileAppInstallTimeSettings> getInstallTimeSettings() {
        return Optional.ofNullable(installTimeSettings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * installTimeSettings} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The install time settings to apply for this app assignment.”</i>
     * 
     * @param installTimeSettings
     *            new value of {@code installTimeSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code installTimeSettings} field changed
     */
    public Win32LobAppAssignmentSettings withInstallTimeSettings(MobileAppInstallTimeSettings installTimeSettings) {
        Win32LobAppAssignmentSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppAssignmentSettings");
        _x.installTimeSettings = installTimeSettings;
        return _x;
    }

    /**
     * <i>“The notification status for this app assignment.”</i>
     * 
     * @return property notifications
     */
    @Property(name="notifications")
    @JsonIgnore
    public Optional<Win32LobAppNotification> getNotifications() {
        return Optional.ofNullable(notifications);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code notifications}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The notification status for this app assignment.”</i>
     * 
     * @param notifications
     *            new value of {@code notifications} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code notifications} field changed
     */
    public Win32LobAppAssignmentSettings withNotifications(Win32LobAppNotification notifications) {
        Win32LobAppAssignmentSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppAssignmentSettings");
        _x.notifications = notifications;
        return _x;
    }

    /**
     * <i>“The reboot settings to apply for this app assignment.”</i>
     * 
     * @return property restartSettings
     */
    @Property(name="restartSettings")
    @JsonIgnore
    public Optional<Win32LobAppRestartSettings> getRestartSettings() {
        return Optional.ofNullable(restartSettings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code restartSettings}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The reboot settings to apply for this app assignment.”</i>
     * 
     * @param restartSettings
     *            new value of {@code restartSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code restartSettings} field changed
     */
    public Win32LobAppAssignmentSettings withRestartSettings(Win32LobAppRestartSettings restartSettings) {
        Win32LobAppAssignmentSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppAssignmentSettings");
        _x.restartSettings = restartSettings;
        return _x;
    }

    public Win32LobAppAssignmentSettings withUnmappedField(String name, Object value) {
        Win32LobAppAssignmentSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWin32LobAppAssignmentSettings() {
        return new Builder();
    }

    public static final class Builder {
        private Win32LobAppDeliveryOptimizationPriority deliveryOptimizationPriority;
        private MobileAppInstallTimeSettings installTimeSettings;
        private Win32LobAppNotification notifications;
        private Win32LobAppRestartSettings restartSettings;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The delivery optimization priority for this app assignment. This setting is not
         * supported in National Cloud environments.”</i>
         * 
         * @param deliveryOptimizationPriority
         *            value of {@code deliveryOptimizationPriority} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deliveryOptimizationPriority(Win32LobAppDeliveryOptimizationPriority deliveryOptimizationPriority) {
            this.deliveryOptimizationPriority = deliveryOptimizationPriority;
            this.changedFields = changedFields.add("deliveryOptimizationPriority");
            return this;
        }

        /**
         * <i>“The install time settings to apply for this app assignment.”</i>
         * 
         * @param installTimeSettings
         *            value of {@code installTimeSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder installTimeSettings(MobileAppInstallTimeSettings installTimeSettings) {
            this.installTimeSettings = installTimeSettings;
            this.changedFields = changedFields.add("installTimeSettings");
            return this;
        }

        /**
         * <i>“The notification status for this app assignment.”</i>
         * 
         * @param notifications
         *            value of {@code notifications} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notifications(Win32LobAppNotification notifications) {
            this.notifications = notifications;
            this.changedFields = changedFields.add("notifications");
            return this;
        }

        /**
         * <i>“The reboot settings to apply for this app assignment.”</i>
         * 
         * @param restartSettings
         *            value of {@code restartSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder restartSettings(Win32LobAppRestartSettings restartSettings) {
            this.restartSettings = restartSettings;
            this.changedFields = changedFields.add("restartSettings");
            return this;
        }

        public Win32LobAppAssignmentSettings build() {
            Win32LobAppAssignmentSettings _x = new Win32LobAppAssignmentSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.win32LobAppAssignmentSettings";
            _x.deliveryOptimizationPriority = deliveryOptimizationPriority;
            _x.installTimeSettings = installTimeSettings;
            _x.notifications = notifications;
            _x.restartSettings = restartSettings;
            return _x;
        }
    }

    private Win32LobAppAssignmentSettings _copy() {
        Win32LobAppAssignmentSettings _x = new Win32LobAppAssignmentSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.deliveryOptimizationPriority = deliveryOptimizationPriority;
        _x.installTimeSettings = installTimeSettings;
        _x.notifications = notifications;
        _x.restartSettings = restartSettings;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Win32LobAppAssignmentSettings[");
        b.append("deliveryOptimizationPriority=");
        b.append(this.deliveryOptimizationPriority);
        b.append(", ");
        b.append("installTimeSettings=");
        b.append(this.installTimeSettings);
        b.append(", ");
        b.append("notifications=");
        b.append(this.notifications);
        b.append(", ");
        b.append("restartSettings=");
        b.append(this.restartSettings);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
