package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "homePageUrl", 
    "implicitGrantSettings", 
    "logoutUrl", 
    "oauth2AllowImplicitFlow", 
    "redirectUris", 
    "redirectUriSettings"})
@JsonInclude(Include.NON_NULL)
public class WebApplication implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("homePageUrl")
    protected String homePageUrl;

    @JsonProperty("implicitGrantSettings")
    protected ImplicitGrantSettings implicitGrantSettings;

    @JsonProperty("logoutUrl")
    protected String logoutUrl;

    @JsonProperty("oauth2AllowImplicitFlow")
    protected Boolean oauth2AllowImplicitFlow;

    @JsonProperty("redirectUris")
    protected List<String> redirectUris;

    @JsonProperty("redirectUris@nextLink")
    protected String redirectUrisNextLink;

    @JsonProperty("redirectUriSettings")
    protected List<RedirectUriSettings> redirectUriSettings;

    @JsonProperty("redirectUriSettings@nextLink")
    protected String redirectUriSettingsNextLink;

    protected WebApplication() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.webApplication";
    }

    @Property(name="homePageUrl")
    @JsonIgnore
    public Optional<String> getHomePageUrl() {
        return Optional.ofNullable(homePageUrl);
    }

    public WebApplication withHomePageUrl(String homePageUrl) {
        WebApplication _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.webApplication");
        _x.homePageUrl = homePageUrl;
        return _x;
    }

    @Property(name="implicitGrantSettings")
    @JsonIgnore
    public Optional<ImplicitGrantSettings> getImplicitGrantSettings() {
        return Optional.ofNullable(implicitGrantSettings);
    }

    public WebApplication withImplicitGrantSettings(ImplicitGrantSettings implicitGrantSettings) {
        WebApplication _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.webApplication");
        _x.implicitGrantSettings = implicitGrantSettings;
        return _x;
    }

    @Property(name="logoutUrl")
    @JsonIgnore
    public Optional<String> getLogoutUrl() {
        return Optional.ofNullable(logoutUrl);
    }

    public WebApplication withLogoutUrl(String logoutUrl) {
        WebApplication _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.webApplication");
        _x.logoutUrl = logoutUrl;
        return _x;
    }

    @Property(name="oauth2AllowImplicitFlow")
    @JsonIgnore
    public Optional<Boolean> getOauth2AllowImplicitFlow() {
        return Optional.ofNullable(oauth2AllowImplicitFlow);
    }

    public WebApplication withOauth2AllowImplicitFlow(Boolean oauth2AllowImplicitFlow) {
        WebApplication _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.webApplication");
        _x.oauth2AllowImplicitFlow = oauth2AllowImplicitFlow;
        return _x;
    }

    @Property(name="redirectUris")
    @JsonIgnore
    public CollectionPage<String> getRedirectUris() {
        return new CollectionPage<String>(contextPath, String.class, this.redirectUris, Optional.ofNullable(redirectUrisNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="redirectUris")
    @JsonIgnore
    public CollectionPage<String> getRedirectUris(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.redirectUris, Optional.ofNullable(redirectUrisNextLink), Collections.emptyList(), options);
    }

    @Property(name="redirectUriSettings")
    @JsonIgnore
    public CollectionPage<RedirectUriSettings> getRedirectUriSettings() {
        return new CollectionPage<RedirectUriSettings>(contextPath, RedirectUriSettings.class, this.redirectUriSettings, Optional.ofNullable(redirectUriSettingsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="redirectUriSettings")
    @JsonIgnore
    public CollectionPage<RedirectUriSettings> getRedirectUriSettings(HttpRequestOptions options) {
        return new CollectionPage<RedirectUriSettings>(contextPath, RedirectUriSettings.class, this.redirectUriSettings, Optional.ofNullable(redirectUriSettingsNextLink), Collections.emptyList(), options);
    }

    public WebApplication withUnmappedField(String name, Object value) {
        WebApplication _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String homePageUrl;
        private ImplicitGrantSettings implicitGrantSettings;
        private String logoutUrl;
        private Boolean oauth2AllowImplicitFlow;
        private List<String> redirectUris;
        private String redirectUrisNextLink;
        private List<RedirectUriSettings> redirectUriSettings;
        private String redirectUriSettingsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder homePageUrl(String homePageUrl) {
            this.homePageUrl = homePageUrl;
            this.changedFields = changedFields.add("homePageUrl");
            return this;
        }

        public Builder implicitGrantSettings(ImplicitGrantSettings implicitGrantSettings) {
            this.implicitGrantSettings = implicitGrantSettings;
            this.changedFields = changedFields.add("implicitGrantSettings");
            return this;
        }

        public Builder logoutUrl(String logoutUrl) {
            this.logoutUrl = logoutUrl;
            this.changedFields = changedFields.add("logoutUrl");
            return this;
        }

        public Builder oauth2AllowImplicitFlow(Boolean oauth2AllowImplicitFlow) {
            this.oauth2AllowImplicitFlow = oauth2AllowImplicitFlow;
            this.changedFields = changedFields.add("oauth2AllowImplicitFlow");
            return this;
        }

        public Builder redirectUris(List<String> redirectUris) {
            this.redirectUris = redirectUris;
            this.changedFields = changedFields.add("redirectUris");
            return this;
        }

        public Builder redirectUris(String... redirectUris) {
            return redirectUris(Arrays.asList(redirectUris));
        }

        public Builder redirectUrisNextLink(String redirectUrisNextLink) {
            this.redirectUrisNextLink = redirectUrisNextLink;
            this.changedFields = changedFields.add("redirectUris");
            return this;
        }

        public Builder redirectUriSettings(List<RedirectUriSettings> redirectUriSettings) {
            this.redirectUriSettings = redirectUriSettings;
            this.changedFields = changedFields.add("redirectUriSettings");
            return this;
        }

        public Builder redirectUriSettings(RedirectUriSettings... redirectUriSettings) {
            return redirectUriSettings(Arrays.asList(redirectUriSettings));
        }

        public Builder redirectUriSettingsNextLink(String redirectUriSettingsNextLink) {
            this.redirectUriSettingsNextLink = redirectUriSettingsNextLink;
            this.changedFields = changedFields.add("redirectUriSettings");
            return this;
        }

        public WebApplication build() {
            WebApplication _x = new WebApplication();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.webApplication";
            _x.homePageUrl = homePageUrl;
            _x.implicitGrantSettings = implicitGrantSettings;
            _x.logoutUrl = logoutUrl;
            _x.oauth2AllowImplicitFlow = oauth2AllowImplicitFlow;
            _x.redirectUris = redirectUris;
            _x.redirectUrisNextLink = redirectUrisNextLink;
            _x.redirectUriSettings = redirectUriSettings;
            _x.redirectUriSettingsNextLink = redirectUriSettingsNextLink;
            return _x;
        }
    }

    private WebApplication _copy() {
        WebApplication _x = new WebApplication();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.homePageUrl = homePageUrl;
        _x.implicitGrantSettings = implicitGrantSettings;
        _x.logoutUrl = logoutUrl;
        _x.oauth2AllowImplicitFlow = oauth2AllowImplicitFlow;
        _x.redirectUris = redirectUris;
        _x.redirectUriSettings = redirectUriSettings;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WebApplication[");
        b.append("homePageUrl=");
        b.append(this.homePageUrl);
        b.append(", ");
        b.append("implicitGrantSettings=");
        b.append(this.implicitGrantSettings);
        b.append(", ");
        b.append("logoutUrl=");
        b.append(this.logoutUrl);
        b.append(", ");
        b.append("oauth2AllowImplicitFlow=");
        b.append(this.oauth2AllowImplicitFlow);
        b.append(", ");
        b.append("redirectUris=");
        b.append(this.redirectUris);
        b.append(", ");
        b.append("redirectUriSettings=");
        b.append(this.redirectUriSettings);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
