package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "cve", 
    "severity", 
    "wasRunning"})
@JsonInclude(Include.NON_NULL)
public class VulnerabilityState implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("cve")
    protected String cve;

    @JsonProperty("severity")
    protected String severity;

    @JsonProperty("wasRunning")
    protected Boolean wasRunning;

    protected VulnerabilityState() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.vulnerabilityState";
    }

    @Property(name="cve")
    @JsonIgnore
    public Optional<String> getCve() {
        return Optional.ofNullable(cve);
    }

    public VulnerabilityState withCve(String cve) {
        VulnerabilityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vulnerabilityState");
        _x.cve = cve;
        return _x;
    }

    @Property(name="severity")
    @JsonIgnore
    public Optional<String> getSeverity() {
        return Optional.ofNullable(severity);
    }

    public VulnerabilityState withSeverity(String severity) {
        VulnerabilityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vulnerabilityState");
        _x.severity = severity;
        return _x;
    }

    @Property(name="wasRunning")
    @JsonIgnore
    public Optional<Boolean> getWasRunning() {
        return Optional.ofNullable(wasRunning);
    }

    public VulnerabilityState withWasRunning(Boolean wasRunning) {
        VulnerabilityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vulnerabilityState");
        _x.wasRunning = wasRunning;
        return _x;
    }

    public VulnerabilityState withUnmappedField(String name, Object value) {
        VulnerabilityState _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String cve;
        private String severity;
        private Boolean wasRunning;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder cve(String cve) {
            this.cve = cve;
            this.changedFields = changedFields.add("cve");
            return this;
        }

        public Builder severity(String severity) {
            this.severity = severity;
            this.changedFields = changedFields.add("severity");
            return this;
        }

        public Builder wasRunning(Boolean wasRunning) {
            this.wasRunning = wasRunning;
            this.changedFields = changedFields.add("wasRunning");
            return this;
        }

        public VulnerabilityState build() {
            VulnerabilityState _x = new VulnerabilityState();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.vulnerabilityState";
            _x.cve = cve;
            _x.severity = severity;
            _x.wasRunning = wasRunning;
            return _x;
        }
    }

    private VulnerabilityState _copy() {
        VulnerabilityState _x = new VulnerabilityState();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.cve = cve;
        _x.severity = severity;
        _x.wasRunning = wasRunning;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("VulnerabilityState[");
        b.append("cve=");
        b.append(this.cve);
        b.append(", ");
        b.append("severity=");
        b.append(this.severity);
        b.append(", ");
        b.append("wasRunning=");
        b.append(this.wasRunning);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
