package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“License summary of a given app in a token.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "appleId", 
    "availableLicenseCount", 
    "organizationName", 
    "usedLicenseCount", 
    "vppTokenId"})
@JsonInclude(Include.NON_NULL)
public class VppTokenLicenseSummary implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("appleId")
    protected String appleId;

    @JsonProperty("availableLicenseCount")
    protected Integer availableLicenseCount;

    @JsonProperty("organizationName")
    protected String organizationName;

    @JsonProperty("usedLicenseCount")
    protected Integer usedLicenseCount;

    @JsonProperty("vppTokenId")
    protected String vppTokenId;

    protected VppTokenLicenseSummary() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.vppTokenLicenseSummary";
    }

    /**
     * <i>“The Apple Id associated with the given Apple Volume Purchase Program Token.”</i>
     * 
     * @return property appleId
     */
    @Property(name="appleId")
    @JsonIgnore
    public Optional<String> getAppleId() {
        return Optional.ofNullable(appleId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appleId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The Apple Id associated with the given Apple Volume Purchase Program Token.”</i>
     * 
     * @param appleId
     *            new value of {@code appleId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appleId} field changed
     */
    public VppTokenLicenseSummary withAppleId(String appleId) {
        VppTokenLicenseSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vppTokenLicenseSummary");
        _x.appleId = appleId;
        return _x;
    }

    /**
     * <i>“The number of VPP licenses available.”</i>
     * 
     * @return property availableLicenseCount
     */
    @Property(name="availableLicenseCount")
    @JsonIgnore
    public Optional<Integer> getAvailableLicenseCount() {
        return Optional.ofNullable(availableLicenseCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * availableLicenseCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The number of VPP licenses available.”</i>
     * 
     * @param availableLicenseCount
     *            new value of {@code availableLicenseCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code availableLicenseCount} field changed
     */
    public VppTokenLicenseSummary withAvailableLicenseCount(Integer availableLicenseCount) {
        VppTokenLicenseSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vppTokenLicenseSummary");
        _x.availableLicenseCount = availableLicenseCount;
        return _x;
    }

    /**
     * <i>“The organization associated with the Apple Volume Purchase Program Token.”</i>
     * 
     * @return property organizationName
     */
    @Property(name="organizationName")
    @JsonIgnore
    public Optional<String> getOrganizationName() {
        return Optional.ofNullable(organizationName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code organizationName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The organization associated with the Apple Volume Purchase Program Token.”</i>
     * 
     * @param organizationName
     *            new value of {@code organizationName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code organizationName} field changed
     */
    public VppTokenLicenseSummary withOrganizationName(String organizationName) {
        VppTokenLicenseSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vppTokenLicenseSummary");
        _x.organizationName = organizationName;
        return _x;
    }

    /**
     * <i>“The number of VPP licenses in use.”</i>
     * 
     * @return property usedLicenseCount
     */
    @Property(name="usedLicenseCount")
    @JsonIgnore
    public Optional<Integer> getUsedLicenseCount() {
        return Optional.ofNullable(usedLicenseCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code usedLicenseCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The number of VPP licenses in use.”</i>
     * 
     * @param usedLicenseCount
     *            new value of {@code usedLicenseCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code usedLicenseCount} field changed
     */
    public VppTokenLicenseSummary withUsedLicenseCount(Integer usedLicenseCount) {
        VppTokenLicenseSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vppTokenLicenseSummary");
        _x.usedLicenseCount = usedLicenseCount;
        return _x;
    }

    /**
     * <i>“Identifier of the VPP token.”</i>
     * 
     * @return property vppTokenId
     */
    @Property(name="vppTokenId")
    @JsonIgnore
    public Optional<String> getVppTokenId() {
        return Optional.ofNullable(vppTokenId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code vppTokenId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Identifier of the VPP token.”</i>
     * 
     * @param vppTokenId
     *            new value of {@code vppTokenId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code vppTokenId} field changed
     */
    public VppTokenLicenseSummary withVppTokenId(String vppTokenId) {
        VppTokenLicenseSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vppTokenLicenseSummary");
        _x.vppTokenId = vppTokenId;
        return _x;
    }

    public VppTokenLicenseSummary withUnmappedField(String name, Object value) {
        VppTokenLicenseSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String appleId;
        private Integer availableLicenseCount;
        private String organizationName;
        private Integer usedLicenseCount;
        private String vppTokenId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The Apple Id associated with the given Apple Volume Purchase Program Token.”</i>
         * 
         * @param appleId
         *            value of {@code appleId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appleId(String appleId) {
            this.appleId = appleId;
            this.changedFields = changedFields.add("appleId");
            return this;
        }

        /**
         * <i>“The number of VPP licenses available.”</i>
         * 
         * @param availableLicenseCount
         *            value of {@code availableLicenseCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder availableLicenseCount(Integer availableLicenseCount) {
            this.availableLicenseCount = availableLicenseCount;
            this.changedFields = changedFields.add("availableLicenseCount");
            return this;
        }

        /**
         * <i>“The organization associated with the Apple Volume Purchase Program Token.”</i>
         * 
         * @param organizationName
         *            value of {@code organizationName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder organizationName(String organizationName) {
            this.organizationName = organizationName;
            this.changedFields = changedFields.add("organizationName");
            return this;
        }

        /**
         * <i>“The number of VPP licenses in use.”</i>
         * 
         * @param usedLicenseCount
         *            value of {@code usedLicenseCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder usedLicenseCount(Integer usedLicenseCount) {
            this.usedLicenseCount = usedLicenseCount;
            this.changedFields = changedFields.add("usedLicenseCount");
            return this;
        }

        /**
         * <i>“Identifier of the VPP token.”</i>
         * 
         * @param vppTokenId
         *            value of {@code vppTokenId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder vppTokenId(String vppTokenId) {
            this.vppTokenId = vppTokenId;
            this.changedFields = changedFields.add("vppTokenId");
            return this;
        }

        public VppTokenLicenseSummary build() {
            VppTokenLicenseSummary _x = new VppTokenLicenseSummary();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.vppTokenLicenseSummary";
            _x.appleId = appleId;
            _x.availableLicenseCount = availableLicenseCount;
            _x.organizationName = organizationName;
            _x.usedLicenseCount = usedLicenseCount;
            _x.vppTokenId = vppTokenId;
            return _x;
        }
    }

    private VppTokenLicenseSummary _copy() {
        VppTokenLicenseSummary _x = new VppTokenLicenseSummary();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.appleId = appleId;
        _x.availableLicenseCount = availableLicenseCount;
        _x.organizationName = organizationName;
        _x.usedLicenseCount = usedLicenseCount;
        _x.vppTokenId = vppTokenId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("VppTokenLicenseSummary[");
        b.append("appleId=");
        b.append(this.appleId);
        b.append(", ");
        b.append("availableLicenseCount=");
        b.append(this.availableLicenseCount);
        b.append(", ");
        b.append("organizationName=");
        b.append(this.organizationName);
        b.append(", ");
        b.append("usedLicenseCount=");
        b.append(this.usedLicenseCount);
        b.append(", ");
        b.append("vppTokenId=");
        b.append(this.vppTokenId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
