package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "body", 
    "title"})
@JsonInclude(Include.NON_NULL)
public class VisualProperties implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("body")
    protected String body;

    @JsonProperty("title")
    protected String title;

    protected VisualProperties() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.visualProperties";
    }

    @Property(name="body")
    @JsonIgnore
    public Optional<String> getBody() {
        return Optional.ofNullable(body);
    }

    public VisualProperties withBody(String body) {
        VisualProperties _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.visualProperties");
        _x.body = body;
        return _x;
    }

    @Property(name="title")
    @JsonIgnore
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    public VisualProperties withTitle(String title) {
        VisualProperties _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.visualProperties");
        _x.title = title;
        return _x;
    }

    public VisualProperties withUnmappedField(String name, Object value) {
        VisualProperties _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String body;
        private String title;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder body(String body) {
            this.body = body;
            this.changedFields = changedFields.add("body");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("title");
            return this;
        }

        public VisualProperties build() {
            VisualProperties _x = new VisualProperties();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.visualProperties";
            _x.body = body;
            _x.title = title;
            return _x;
        }
    }

    private VisualProperties _copy() {
        VisualProperties _x = new VisualProperties();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.body = body;
        _x.title = title;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("VisualProperties[");
        b.append("body=");
        b.append(this.body);
        b.append(", ");
        b.append("title=");
        b.append(this.title);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
