package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "attribution", 
    "backgroundColor", 
    "content", 
    "description", 
    "displayText"})
@JsonInclude(Include.NON_NULL)
public class VisualInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("attribution")
    protected ImageInfo attribution;

    @JsonProperty("backgroundColor")
    protected String backgroundColor;

    @JsonProperty("content")
    protected Json content;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayText")
    protected String displayText;

    protected VisualInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.visualInfo";
    }

    @Property(name="attribution")
    @JsonIgnore
    public Optional<ImageInfo> getAttribution() {
        return Optional.ofNullable(attribution);
    }

    public VisualInfo withAttribution(ImageInfo attribution) {
        VisualInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.visualInfo");
        _x.attribution = attribution;
        return _x;
    }

    @Property(name="backgroundColor")
    @JsonIgnore
    public Optional<String> getBackgroundColor() {
        return Optional.ofNullable(backgroundColor);
    }

    public VisualInfo withBackgroundColor(String backgroundColor) {
        VisualInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.visualInfo");
        _x.backgroundColor = backgroundColor;
        return _x;
    }

    @Property(name="content")
    @JsonIgnore
    public Optional<Json> getContent() {
        return Optional.ofNullable(content);
    }

    public VisualInfo withContent(Json content) {
        VisualInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.visualInfo");
        _x.content = content;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public VisualInfo withDescription(String description) {
        VisualInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.visualInfo");
        _x.description = description;
        return _x;
    }

    @Property(name="displayText")
    @JsonIgnore
    public Optional<String> getDisplayText() {
        return Optional.ofNullable(displayText);
    }

    public VisualInfo withDisplayText(String displayText) {
        VisualInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.visualInfo");
        _x.displayText = displayText;
        return _x;
    }

    public VisualInfo withUnmappedField(String name, Object value) {
        VisualInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ImageInfo attribution;
        private String backgroundColor;
        private Json content;
        private String description;
        private String displayText;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder attribution(ImageInfo attribution) {
            this.attribution = attribution;
            this.changedFields = changedFields.add("attribution");
            return this;
        }

        public Builder backgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
            this.changedFields = changedFields.add("backgroundColor");
            return this;
        }

        public Builder content(Json content) {
            this.content = content;
            this.changedFields = changedFields.add("content");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayText(String displayText) {
            this.displayText = displayText;
            this.changedFields = changedFields.add("displayText");
            return this;
        }

        public VisualInfo build() {
            VisualInfo _x = new VisualInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.visualInfo";
            _x.attribution = attribution;
            _x.backgroundColor = backgroundColor;
            _x.content = content;
            _x.description = description;
            _x.displayText = displayText;
            return _x;
        }
    }

    private VisualInfo _copy() {
        VisualInfo _x = new VisualInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.attribution = attribution;
        _x.backgroundColor = backgroundColor;
        _x.content = content;
        _x.description = description;
        _x.displayText = displayText;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("VisualInfo[");
        b.append("attribution=");
        b.append(this.attribution);
        b.append(", ");
        b.append("backgroundColor=");
        b.append(this.backgroundColor);
        b.append(", ");
        b.append("content=");
        b.append(this.content);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayText=");
        b.append(this.displayText);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
