package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "capabilities", 
    "isDefault", 
    "isInitial", 
    "name", 
    "type"})
@JsonInclude(Include.NON_NULL)
public class VerifiedDomain implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("capabilities")
    protected String capabilities;

    @JsonProperty("isDefault")
    protected Boolean isDefault;

    @JsonProperty("isInitial")
    protected Boolean isInitial;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("type")
    protected String type;

    protected VerifiedDomain() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.verifiedDomain";
    }

    @Property(name="capabilities")
    @JsonIgnore
    public Optional<String> getCapabilities() {
        return Optional.ofNullable(capabilities);
    }

    public VerifiedDomain withCapabilities(String capabilities) {
        VerifiedDomain _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.verifiedDomain");
        _x.capabilities = capabilities;
        return _x;
    }

    @Property(name="isDefault")
    @JsonIgnore
    public Optional<Boolean> getIsDefault() {
        return Optional.ofNullable(isDefault);
    }

    public VerifiedDomain withIsDefault(Boolean isDefault) {
        VerifiedDomain _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.verifiedDomain");
        _x.isDefault = isDefault;
        return _x;
    }

    @Property(name="isInitial")
    @JsonIgnore
    public Optional<Boolean> getIsInitial() {
        return Optional.ofNullable(isInitial);
    }

    public VerifiedDomain withIsInitial(Boolean isInitial) {
        VerifiedDomain _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.verifiedDomain");
        _x.isInitial = isInitial;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public VerifiedDomain withName(String name) {
        VerifiedDomain _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.verifiedDomain");
        _x.name = name;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    public VerifiedDomain withType(String type) {
        VerifiedDomain _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.verifiedDomain");
        _x.type = type;
        return _x;
    }

    public VerifiedDomain withUnmappedField(String name, Object value) {
        VerifiedDomain _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String capabilities;
        private Boolean isDefault;
        private Boolean isInitial;
        private String name;
        private String type;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder capabilities(String capabilities) {
            this.capabilities = capabilities;
            this.changedFields = changedFields.add("capabilities");
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.changedFields = changedFields.add("isDefault");
            return this;
        }

        public Builder isInitial(Boolean isInitial) {
            this.isInitial = isInitial;
            this.changedFields = changedFields.add("isInitial");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public VerifiedDomain build() {
            VerifiedDomain _x = new VerifiedDomain();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.verifiedDomain";
            _x.capabilities = capabilities;
            _x.isDefault = isDefault;
            _x.isInitial = isInitial;
            _x.name = name;
            _x.type = type;
            return _x;
        }
    }

    private VerifiedDomain _copy() {
        VerifiedDomain _x = new VerifiedDomain();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.capabilities = capabilities;
        _x.isDefault = isDefault;
        _x.isInitial = isInitial;
        _x.name = name;
        _x.type = type;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("VerifiedDomain[");
        b.append("capabilities=");
        b.append(this.capabilities);
        b.append(", ");
        b.append("isDefault=");
        b.append(this.isDefault);
        b.append(", ");
        b.append("isInitial=");
        b.append(this.isInitial);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
