package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.TrainingStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "assignedDateTime", 
    "completionDateTime", 
    "displayName", 
    "trainingStatus"})
@JsonInclude(Include.NON_NULL)
public class UserTrainingStatusInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("assignedDateTime")
    protected OffsetDateTime assignedDateTime;

    @JsonProperty("completionDateTime")
    protected OffsetDateTime completionDateTime;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("trainingStatus")
    protected TrainingStatus trainingStatus;

    protected UserTrainingStatusInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userTrainingStatusInfo";
    }

    @Property(name="assignedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getAssignedDateTime() {
        return Optional.ofNullable(assignedDateTime);
    }

    public UserTrainingStatusInfo withAssignedDateTime(OffsetDateTime assignedDateTime) {
        UserTrainingStatusInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userTrainingStatusInfo");
        _x.assignedDateTime = assignedDateTime;
        return _x;
    }

    @Property(name="completionDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCompletionDateTime() {
        return Optional.ofNullable(completionDateTime);
    }

    public UserTrainingStatusInfo withCompletionDateTime(OffsetDateTime completionDateTime) {
        UserTrainingStatusInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userTrainingStatusInfo");
        _x.completionDateTime = completionDateTime;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public UserTrainingStatusInfo withDisplayName(String displayName) {
        UserTrainingStatusInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userTrainingStatusInfo");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="trainingStatus")
    @JsonIgnore
    public Optional<TrainingStatus> getTrainingStatus() {
        return Optional.ofNullable(trainingStatus);
    }

    public UserTrainingStatusInfo withTrainingStatus(TrainingStatus trainingStatus) {
        UserTrainingStatusInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userTrainingStatusInfo");
        _x.trainingStatus = trainingStatus;
        return _x;
    }

    public UserTrainingStatusInfo withUnmappedField(String name, Object value) {
        UserTrainingStatusInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime assignedDateTime;
        private OffsetDateTime completionDateTime;
        private String displayName;
        private TrainingStatus trainingStatus;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder assignedDateTime(OffsetDateTime assignedDateTime) {
            this.assignedDateTime = assignedDateTime;
            this.changedFields = changedFields.add("assignedDateTime");
            return this;
        }

        public Builder completionDateTime(OffsetDateTime completionDateTime) {
            this.completionDateTime = completionDateTime;
            this.changedFields = changedFields.add("completionDateTime");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder trainingStatus(TrainingStatus trainingStatus) {
            this.trainingStatus = trainingStatus;
            this.changedFields = changedFields.add("trainingStatus");
            return this;
        }

        public UserTrainingStatusInfo build() {
            UserTrainingStatusInfo _x = new UserTrainingStatusInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userTrainingStatusInfo";
            _x.assignedDateTime = assignedDateTime;
            _x.completionDateTime = completionDateTime;
            _x.displayName = displayName;
            _x.trainingStatus = trainingStatus;
            return _x;
        }
    }

    private UserTrainingStatusInfo _copy() {
        UserTrainingStatusInfo _x = new UserTrainingStatusInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.assignedDateTime = assignedDateTime;
        _x.completionDateTime = completionDateTime;
        _x.displayName = displayName;
        _x.trainingStatus = trainingStatus;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserTrainingStatusInfo[");
        b.append("assignedDateTime=");
        b.append(this.assignedDateTime);
        b.append(", ");
        b.append("completionDateTime=");
        b.append(this.completionDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("trainingStatus=");
        b.append(this.trainingStatus);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
