package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Double;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "browser", 
    "contentDateTime", 
    "ipAddress", 
    "osPlatformDeviceDetails", 
    "potentialScoreImpact"})
@JsonInclude(Include.NON_NULL)
public class UserTrainingContentEventInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("browser")
    protected String browser;

    @JsonProperty("contentDateTime")
    protected OffsetDateTime contentDateTime;

    @JsonProperty("ipAddress")
    protected String ipAddress;

    @JsonProperty("osPlatformDeviceDetails")
    protected String osPlatformDeviceDetails;

    @JsonProperty("potentialScoreImpact")
    protected Double potentialScoreImpact;

    protected UserTrainingContentEventInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userTrainingContentEventInfo";
    }

    @Property(name="browser")
    @JsonIgnore
    public Optional<String> getBrowser() {
        return Optional.ofNullable(browser);
    }

    public UserTrainingContentEventInfo withBrowser(String browser) {
        UserTrainingContentEventInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userTrainingContentEventInfo");
        _x.browser = browser;
        return _x;
    }

    @Property(name="contentDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getContentDateTime() {
        return Optional.ofNullable(contentDateTime);
    }

    public UserTrainingContentEventInfo withContentDateTime(OffsetDateTime contentDateTime) {
        UserTrainingContentEventInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userTrainingContentEventInfo");
        _x.contentDateTime = contentDateTime;
        return _x;
    }

    @Property(name="ipAddress")
    @JsonIgnore
    public Optional<String> getIpAddress() {
        return Optional.ofNullable(ipAddress);
    }

    public UserTrainingContentEventInfo withIpAddress(String ipAddress) {
        UserTrainingContentEventInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userTrainingContentEventInfo");
        _x.ipAddress = ipAddress;
        return _x;
    }

    @Property(name="osPlatformDeviceDetails")
    @JsonIgnore
    public Optional<String> getOsPlatformDeviceDetails() {
        return Optional.ofNullable(osPlatformDeviceDetails);
    }

    public UserTrainingContentEventInfo withOsPlatformDeviceDetails(String osPlatformDeviceDetails) {
        UserTrainingContentEventInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userTrainingContentEventInfo");
        _x.osPlatformDeviceDetails = osPlatformDeviceDetails;
        return _x;
    }

    @Property(name="potentialScoreImpact")
    @JsonIgnore
    public Optional<Double> getPotentialScoreImpact() {
        return Optional.ofNullable(potentialScoreImpact);
    }

    public UserTrainingContentEventInfo withPotentialScoreImpact(Double potentialScoreImpact) {
        UserTrainingContentEventInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userTrainingContentEventInfo");
        _x.potentialScoreImpact = potentialScoreImpact;
        return _x;
    }

    public UserTrainingContentEventInfo withUnmappedField(String name, Object value) {
        UserTrainingContentEventInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String browser;
        private OffsetDateTime contentDateTime;
        private String ipAddress;
        private String osPlatformDeviceDetails;
        private Double potentialScoreImpact;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder browser(String browser) {
            this.browser = browser;
            this.changedFields = changedFields.add("browser");
            return this;
        }

        public Builder contentDateTime(OffsetDateTime contentDateTime) {
            this.contentDateTime = contentDateTime;
            this.changedFields = changedFields.add("contentDateTime");
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            this.changedFields = changedFields.add("ipAddress");
            return this;
        }

        public Builder osPlatformDeviceDetails(String osPlatformDeviceDetails) {
            this.osPlatformDeviceDetails = osPlatformDeviceDetails;
            this.changedFields = changedFields.add("osPlatformDeviceDetails");
            return this;
        }

        public Builder potentialScoreImpact(Double potentialScoreImpact) {
            this.potentialScoreImpact = potentialScoreImpact;
            this.changedFields = changedFields.add("potentialScoreImpact");
            return this;
        }

        public UserTrainingContentEventInfo build() {
            UserTrainingContentEventInfo _x = new UserTrainingContentEventInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userTrainingContentEventInfo";
            _x.browser = browser;
            _x.contentDateTime = contentDateTime;
            _x.ipAddress = ipAddress;
            _x.osPlatformDeviceDetails = osPlatformDeviceDetails;
            _x.potentialScoreImpact = potentialScoreImpact;
            return _x;
        }
    }

    private UserTrainingContentEventInfo _copy() {
        UserTrainingContentEventInfo _x = new UserTrainingContentEventInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.browser = browser;
        _x.contentDateTime = contentDateTime;
        _x.ipAddress = ipAddress;
        _x.osPlatformDeviceDetails = osPlatformDeviceDetails;
        _x.potentialScoreImpact = potentialScoreImpact;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserTrainingContentEventInfo[");
        b.append("browser=");
        b.append(this.browser);
        b.append(", ");
        b.append("contentDateTime=");
        b.append(this.contentDateTime);
        b.append(", ");
        b.append("ipAddress=");
        b.append(this.ipAddress);
        b.append(", ");
        b.append("osPlatformDeviceDetails=");
        b.append(this.osPlatformDeviceDetails);
        b.append(", ");
        b.append("potentialScoreImpact=");
        b.append(this.potentialScoreImpact);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
