package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "browser", 
    "eventDateTime", 
    "eventName", 
    "ipAddress", 
    "osPlatformDeviceDetails"})
@JsonInclude(Include.NON_NULL)
public class UserSimulationEventInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("browser")
    protected String browser;

    @JsonProperty("eventDateTime")
    protected OffsetDateTime eventDateTime;

    @JsonProperty("eventName")
    protected String eventName;

    @JsonProperty("ipAddress")
    protected String ipAddress;

    @JsonProperty("osPlatformDeviceDetails")
    protected String osPlatformDeviceDetails;

    protected UserSimulationEventInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userSimulationEventInfo";
    }

    @Property(name="browser")
    @JsonIgnore
    public Optional<String> getBrowser() {
        return Optional.ofNullable(browser);
    }

    public UserSimulationEventInfo withBrowser(String browser) {
        UserSimulationEventInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userSimulationEventInfo");
        _x.browser = browser;
        return _x;
    }

    @Property(name="eventDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEventDateTime() {
        return Optional.ofNullable(eventDateTime);
    }

    public UserSimulationEventInfo withEventDateTime(OffsetDateTime eventDateTime) {
        UserSimulationEventInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userSimulationEventInfo");
        _x.eventDateTime = eventDateTime;
        return _x;
    }

    @Property(name="eventName")
    @JsonIgnore
    public Optional<String> getEventName() {
        return Optional.ofNullable(eventName);
    }

    public UserSimulationEventInfo withEventName(String eventName) {
        UserSimulationEventInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userSimulationEventInfo");
        _x.eventName = eventName;
        return _x;
    }

    @Property(name="ipAddress")
    @JsonIgnore
    public Optional<String> getIpAddress() {
        return Optional.ofNullable(ipAddress);
    }

    public UserSimulationEventInfo withIpAddress(String ipAddress) {
        UserSimulationEventInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userSimulationEventInfo");
        _x.ipAddress = ipAddress;
        return _x;
    }

    @Property(name="osPlatformDeviceDetails")
    @JsonIgnore
    public Optional<String> getOsPlatformDeviceDetails() {
        return Optional.ofNullable(osPlatformDeviceDetails);
    }

    public UserSimulationEventInfo withOsPlatformDeviceDetails(String osPlatformDeviceDetails) {
        UserSimulationEventInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userSimulationEventInfo");
        _x.osPlatformDeviceDetails = osPlatformDeviceDetails;
        return _x;
    }

    public UserSimulationEventInfo withUnmappedField(String name, Object value) {
        UserSimulationEventInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String browser;
        private OffsetDateTime eventDateTime;
        private String eventName;
        private String ipAddress;
        private String osPlatformDeviceDetails;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder browser(String browser) {
            this.browser = browser;
            this.changedFields = changedFields.add("browser");
            return this;
        }

        public Builder eventDateTime(OffsetDateTime eventDateTime) {
            this.eventDateTime = eventDateTime;
            this.changedFields = changedFields.add("eventDateTime");
            return this;
        }

        public Builder eventName(String eventName) {
            this.eventName = eventName;
            this.changedFields = changedFields.add("eventName");
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            this.changedFields = changedFields.add("ipAddress");
            return this;
        }

        public Builder osPlatformDeviceDetails(String osPlatformDeviceDetails) {
            this.osPlatformDeviceDetails = osPlatformDeviceDetails;
            this.changedFields = changedFields.add("osPlatformDeviceDetails");
            return this;
        }

        public UserSimulationEventInfo build() {
            UserSimulationEventInfo _x = new UserSimulationEventInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userSimulationEventInfo";
            _x.browser = browser;
            _x.eventDateTime = eventDateTime;
            _x.eventName = eventName;
            _x.ipAddress = ipAddress;
            _x.osPlatformDeviceDetails = osPlatformDeviceDetails;
            return _x;
        }
    }

    private UserSimulationEventInfo _copy() {
        UserSimulationEventInfo _x = new UserSimulationEventInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.browser = browser;
        _x.eventDateTime = eventDateTime;
        _x.eventName = eventName;
        _x.ipAddress = ipAddress;
        _x.osPlatformDeviceDetails = osPlatformDeviceDetails;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserSimulationEventInfo[");
        b.append("browser=");
        b.append(this.browser);
        b.append(", ");
        b.append("eventDateTime=");
        b.append(this.eventDateTime);
        b.append(", ");
        b.append("eventName=");
        b.append(this.eventName);
        b.append(", ");
        b.append("ipAddress=");
        b.append(this.ipAddress);
        b.append(", ");
        b.append("osPlatformDeviceDetails=");
        b.append(this.osPlatformDeviceDetails);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
