package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.EmailRole;
import odata.msgraph.client.beta.enums.LogonType;
import odata.msgraph.client.beta.enums.UserAccountSecurityType;

@JsonPropertyOrder({
    "@odata.type", 
    "aadUserId", 
    "accountName", 
    "domainName", 
    "emailRole", 
    "isVpn", 
    "logonDateTime", 
    "logonId", 
    "logonIp", 
    "logonLocation", 
    "logonType", 
    "onPremisesSecurityIdentifier", 
    "riskScore", 
    "userAccountType", 
    "userPrincipalName"})
@JsonInclude(Include.NON_NULL)
public class UserSecurityState implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("aadUserId")
    protected String aadUserId;

    @JsonProperty("accountName")
    protected String accountName;

    @JsonProperty("domainName")
    protected String domainName;

    @JsonProperty("emailRole")
    protected EmailRole emailRole;

    @JsonProperty("isVpn")
    protected Boolean isVpn;

    @JsonProperty("logonDateTime")
    protected OffsetDateTime logonDateTime;

    @JsonProperty("logonId")
    protected String logonId;

    @JsonProperty("logonIp")
    protected String logonIp;

    @JsonProperty("logonLocation")
    protected String logonLocation;

    @JsonProperty("logonType")
    protected LogonType logonType;

    @JsonProperty("onPremisesSecurityIdentifier")
    protected String onPremisesSecurityIdentifier;

    @JsonProperty("riskScore")
    protected String riskScore;

    @JsonProperty("userAccountType")
    protected UserAccountSecurityType userAccountType;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    protected UserSecurityState() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userSecurityState";
    }

    @Property(name="aadUserId")
    @JsonIgnore
    public Optional<String> getAadUserId() {
        return Optional.ofNullable(aadUserId);
    }

    public UserSecurityState withAadUserId(String aadUserId) {
        UserSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userSecurityState");
        _x.aadUserId = aadUserId;
        return _x;
    }

    @Property(name="accountName")
    @JsonIgnore
    public Optional<String> getAccountName() {
        return Optional.ofNullable(accountName);
    }

    public UserSecurityState withAccountName(String accountName) {
        UserSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userSecurityState");
        _x.accountName = accountName;
        return _x;
    }

    @Property(name="domainName")
    @JsonIgnore
    public Optional<String> getDomainName() {
        return Optional.ofNullable(domainName);
    }

    public UserSecurityState withDomainName(String domainName) {
        UserSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userSecurityState");
        _x.domainName = domainName;
        return _x;
    }

    @Property(name="emailRole")
    @JsonIgnore
    public Optional<EmailRole> getEmailRole() {
        return Optional.ofNullable(emailRole);
    }

    public UserSecurityState withEmailRole(EmailRole emailRole) {
        UserSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userSecurityState");
        _x.emailRole = emailRole;
        return _x;
    }

    @Property(name="isVpn")
    @JsonIgnore
    public Optional<Boolean> getIsVpn() {
        return Optional.ofNullable(isVpn);
    }

    public UserSecurityState withIsVpn(Boolean isVpn) {
        UserSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userSecurityState");
        _x.isVpn = isVpn;
        return _x;
    }

    @Property(name="logonDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLogonDateTime() {
        return Optional.ofNullable(logonDateTime);
    }

    public UserSecurityState withLogonDateTime(OffsetDateTime logonDateTime) {
        UserSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userSecurityState");
        _x.logonDateTime = logonDateTime;
        return _x;
    }

    @Property(name="logonId")
    @JsonIgnore
    public Optional<String> getLogonId() {
        return Optional.ofNullable(logonId);
    }

    public UserSecurityState withLogonId(String logonId) {
        UserSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userSecurityState");
        _x.logonId = logonId;
        return _x;
    }

    @Property(name="logonIp")
    @JsonIgnore
    public Optional<String> getLogonIp() {
        return Optional.ofNullable(logonIp);
    }

    public UserSecurityState withLogonIp(String logonIp) {
        UserSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userSecurityState");
        _x.logonIp = logonIp;
        return _x;
    }

    @Property(name="logonLocation")
    @JsonIgnore
    public Optional<String> getLogonLocation() {
        return Optional.ofNullable(logonLocation);
    }

    public UserSecurityState withLogonLocation(String logonLocation) {
        UserSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userSecurityState");
        _x.logonLocation = logonLocation;
        return _x;
    }

    @Property(name="logonType")
    @JsonIgnore
    public Optional<LogonType> getLogonType() {
        return Optional.ofNullable(logonType);
    }

    public UserSecurityState withLogonType(LogonType logonType) {
        UserSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userSecurityState");
        _x.logonType = logonType;
        return _x;
    }

    @Property(name="onPremisesSecurityIdentifier")
    @JsonIgnore
    public Optional<String> getOnPremisesSecurityIdentifier() {
        return Optional.ofNullable(onPremisesSecurityIdentifier);
    }

    public UserSecurityState withOnPremisesSecurityIdentifier(String onPremisesSecurityIdentifier) {
        UserSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userSecurityState");
        _x.onPremisesSecurityIdentifier = onPremisesSecurityIdentifier;
        return _x;
    }

    @Property(name="riskScore")
    @JsonIgnore
    public Optional<String> getRiskScore() {
        return Optional.ofNullable(riskScore);
    }

    public UserSecurityState withRiskScore(String riskScore) {
        UserSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userSecurityState");
        _x.riskScore = riskScore;
        return _x;
    }

    @Property(name="userAccountType")
    @JsonIgnore
    public Optional<UserAccountSecurityType> getUserAccountType() {
        return Optional.ofNullable(userAccountType);
    }

    public UserSecurityState withUserAccountType(UserAccountSecurityType userAccountType) {
        UserSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userSecurityState");
        _x.userAccountType = userAccountType;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public UserSecurityState withUserPrincipalName(String userPrincipalName) {
        UserSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userSecurityState");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    public UserSecurityState withUnmappedField(String name, Object value) {
        UserSecurityState _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String aadUserId;
        private String accountName;
        private String domainName;
        private EmailRole emailRole;
        private Boolean isVpn;
        private OffsetDateTime logonDateTime;
        private String logonId;
        private String logonIp;
        private String logonLocation;
        private LogonType logonType;
        private String onPremisesSecurityIdentifier;
        private String riskScore;
        private UserAccountSecurityType userAccountType;
        private String userPrincipalName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder aadUserId(String aadUserId) {
            this.aadUserId = aadUserId;
            this.changedFields = changedFields.add("aadUserId");
            return this;
        }

        public Builder accountName(String accountName) {
            this.accountName = accountName;
            this.changedFields = changedFields.add("accountName");
            return this;
        }

        public Builder domainName(String domainName) {
            this.domainName = domainName;
            this.changedFields = changedFields.add("domainName");
            return this;
        }

        public Builder emailRole(EmailRole emailRole) {
            this.emailRole = emailRole;
            this.changedFields = changedFields.add("emailRole");
            return this;
        }

        public Builder isVpn(Boolean isVpn) {
            this.isVpn = isVpn;
            this.changedFields = changedFields.add("isVpn");
            return this;
        }

        public Builder logonDateTime(OffsetDateTime logonDateTime) {
            this.logonDateTime = logonDateTime;
            this.changedFields = changedFields.add("logonDateTime");
            return this;
        }

        public Builder logonId(String logonId) {
            this.logonId = logonId;
            this.changedFields = changedFields.add("logonId");
            return this;
        }

        public Builder logonIp(String logonIp) {
            this.logonIp = logonIp;
            this.changedFields = changedFields.add("logonIp");
            return this;
        }

        public Builder logonLocation(String logonLocation) {
            this.logonLocation = logonLocation;
            this.changedFields = changedFields.add("logonLocation");
            return this;
        }

        public Builder logonType(LogonType logonType) {
            this.logonType = logonType;
            this.changedFields = changedFields.add("logonType");
            return this;
        }

        public Builder onPremisesSecurityIdentifier(String onPremisesSecurityIdentifier) {
            this.onPremisesSecurityIdentifier = onPremisesSecurityIdentifier;
            this.changedFields = changedFields.add("onPremisesSecurityIdentifier");
            return this;
        }

        public Builder riskScore(String riskScore) {
            this.riskScore = riskScore;
            this.changedFields = changedFields.add("riskScore");
            return this;
        }

        public Builder userAccountType(UserAccountSecurityType userAccountType) {
            this.userAccountType = userAccountType;
            this.changedFields = changedFields.add("userAccountType");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public UserSecurityState build() {
            UserSecurityState _x = new UserSecurityState();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userSecurityState";
            _x.aadUserId = aadUserId;
            _x.accountName = accountName;
            _x.domainName = domainName;
            _x.emailRole = emailRole;
            _x.isVpn = isVpn;
            _x.logonDateTime = logonDateTime;
            _x.logonId = logonId;
            _x.logonIp = logonIp;
            _x.logonLocation = logonLocation;
            _x.logonType = logonType;
            _x.onPremisesSecurityIdentifier = onPremisesSecurityIdentifier;
            _x.riskScore = riskScore;
            _x.userAccountType = userAccountType;
            _x.userPrincipalName = userPrincipalName;
            return _x;
        }
    }

    private UserSecurityState _copy() {
        UserSecurityState _x = new UserSecurityState();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.aadUserId = aadUserId;
        _x.accountName = accountName;
        _x.domainName = domainName;
        _x.emailRole = emailRole;
        _x.isVpn = isVpn;
        _x.logonDateTime = logonDateTime;
        _x.logonId = logonId;
        _x.logonIp = logonIp;
        _x.logonLocation = logonLocation;
        _x.logonType = logonType;
        _x.onPremisesSecurityIdentifier = onPremisesSecurityIdentifier;
        _x.riskScore = riskScore;
        _x.userAccountType = userAccountType;
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserSecurityState[");
        b.append("aadUserId=");
        b.append(this.aadUserId);
        b.append(", ");
        b.append("accountName=");
        b.append(this.accountName);
        b.append(", ");
        b.append("domainName=");
        b.append(this.domainName);
        b.append(", ");
        b.append("emailRole=");
        b.append(this.emailRole);
        b.append(", ");
        b.append("isVpn=");
        b.append(this.isVpn);
        b.append(", ");
        b.append("logonDateTime=");
        b.append(this.logonDateTime);
        b.append(", ");
        b.append("logonId=");
        b.append(this.logonId);
        b.append(", ");
        b.append("logonIp=");
        b.append(this.logonIp);
        b.append(", ");
        b.append("logonLocation=");
        b.append(this.logonLocation);
        b.append(", ");
        b.append("logonType=");
        b.append(this.logonType);
        b.append(", ");
        b.append("onPremisesSecurityIdentifier=");
        b.append(this.onPremisesSecurityIdentifier);
        b.append(", ");
        b.append("riskScore=");
        b.append(this.riskScore);
        b.append(", ");
        b.append("userAccountType=");
        b.append(this.userAccountType);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
