package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.IncludedUserRoles;
import odata.msgraph.client.beta.enums.IncludedUserTypes;

@JsonPropertyOrder({
    "@odata.type", 
    "totalUserCount", 
    "userRegistrationMethodCounts", 
    "userRoles", 
    "userTypes"})
@JsonInclude(Include.NON_NULL)
public class UserRegistrationMethodSummary implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("totalUserCount")
    protected Long totalUserCount;

    @JsonProperty("userRegistrationMethodCounts")
    protected List<UserRegistrationMethodCount> userRegistrationMethodCounts;

    @JsonProperty("userRegistrationMethodCounts@nextLink")
    protected String userRegistrationMethodCountsNextLink;

    @JsonProperty("userRoles")
    protected IncludedUserRoles userRoles;

    @JsonProperty("userTypes")
    protected IncludedUserTypes userTypes;

    protected UserRegistrationMethodSummary() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userRegistrationMethodSummary";
    }

    @Property(name="totalUserCount")
    @JsonIgnore
    public Optional<Long> getTotalUserCount() {
        return Optional.ofNullable(totalUserCount);
    }

    public UserRegistrationMethodSummary withTotalUserCount(Long totalUserCount) {
        UserRegistrationMethodSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userRegistrationMethodSummary");
        _x.totalUserCount = totalUserCount;
        return _x;
    }

    @Property(name="userRegistrationMethodCounts")
    @JsonIgnore
    public CollectionPage<UserRegistrationMethodCount> getUserRegistrationMethodCounts() {
        return new CollectionPage<UserRegistrationMethodCount>(contextPath, UserRegistrationMethodCount.class, this.userRegistrationMethodCounts, Optional.ofNullable(userRegistrationMethodCountsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="userRegistrationMethodCounts")
    @JsonIgnore
    public CollectionPage<UserRegistrationMethodCount> getUserRegistrationMethodCounts(HttpRequestOptions options) {
        return new CollectionPage<UserRegistrationMethodCount>(contextPath, UserRegistrationMethodCount.class, this.userRegistrationMethodCounts, Optional.ofNullable(userRegistrationMethodCountsNextLink), Collections.emptyList(), options);
    }

    @Property(name="userRoles")
    @JsonIgnore
    public Optional<IncludedUserRoles> getUserRoles() {
        return Optional.ofNullable(userRoles);
    }

    public UserRegistrationMethodSummary withUserRoles(IncludedUserRoles userRoles) {
        UserRegistrationMethodSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userRegistrationMethodSummary");
        _x.userRoles = userRoles;
        return _x;
    }

    @Property(name="userTypes")
    @JsonIgnore
    public Optional<IncludedUserTypes> getUserTypes() {
        return Optional.ofNullable(userTypes);
    }

    public UserRegistrationMethodSummary withUserTypes(IncludedUserTypes userTypes) {
        UserRegistrationMethodSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userRegistrationMethodSummary");
        _x.userTypes = userTypes;
        return _x;
    }

    public UserRegistrationMethodSummary withUnmappedField(String name, Object value) {
        UserRegistrationMethodSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Long totalUserCount;
        private List<UserRegistrationMethodCount> userRegistrationMethodCounts;
        private String userRegistrationMethodCountsNextLink;
        private IncludedUserRoles userRoles;
        private IncludedUserTypes userTypes;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder totalUserCount(Long totalUserCount) {
            this.totalUserCount = totalUserCount;
            this.changedFields = changedFields.add("totalUserCount");
            return this;
        }

        public Builder userRegistrationMethodCounts(List<UserRegistrationMethodCount> userRegistrationMethodCounts) {
            this.userRegistrationMethodCounts = userRegistrationMethodCounts;
            this.changedFields = changedFields.add("userRegistrationMethodCounts");
            return this;
        }

        public Builder userRegistrationMethodCounts(UserRegistrationMethodCount... userRegistrationMethodCounts) {
            return userRegistrationMethodCounts(Arrays.asList(userRegistrationMethodCounts));
        }

        public Builder userRegistrationMethodCountsNextLink(String userRegistrationMethodCountsNextLink) {
            this.userRegistrationMethodCountsNextLink = userRegistrationMethodCountsNextLink;
            this.changedFields = changedFields.add("userRegistrationMethodCounts");
            return this;
        }

        public Builder userRoles(IncludedUserRoles userRoles) {
            this.userRoles = userRoles;
            this.changedFields = changedFields.add("userRoles");
            return this;
        }

        public Builder userTypes(IncludedUserTypes userTypes) {
            this.userTypes = userTypes;
            this.changedFields = changedFields.add("userTypes");
            return this;
        }

        public UserRegistrationMethodSummary build() {
            UserRegistrationMethodSummary _x = new UserRegistrationMethodSummary();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userRegistrationMethodSummary";
            _x.totalUserCount = totalUserCount;
            _x.userRegistrationMethodCounts = userRegistrationMethodCounts;
            _x.userRegistrationMethodCountsNextLink = userRegistrationMethodCountsNextLink;
            _x.userRoles = userRoles;
            _x.userTypes = userTypes;
            return _x;
        }
    }

    private UserRegistrationMethodSummary _copy() {
        UserRegistrationMethodSummary _x = new UserRegistrationMethodSummary();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.totalUserCount = totalUserCount;
        _x.userRegistrationMethodCounts = userRegistrationMethodCounts;
        _x.userRoles = userRoles;
        _x.userTypes = userTypes;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserRegistrationMethodSummary[");
        b.append("totalUserCount=");
        b.append(this.totalUserCount);
        b.append(", ");
        b.append("userRegistrationMethodCounts=");
        b.append(this.userRegistrationMethodCounts);
        b.append(", ");
        b.append("userRoles=");
        b.append(this.userRoles);
        b.append(", ");
        b.append("userTypes=");
        b.append(this.userTypes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
