package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "authenticationMethod", 
    "userCount"})
@JsonInclude(Include.NON_NULL)
public class UserRegistrationMethodCount implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("authenticationMethod")
    protected String authenticationMethod;

    @JsonProperty("userCount")
    protected Long userCount;

    protected UserRegistrationMethodCount() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userRegistrationMethodCount";
    }

    @Property(name="authenticationMethod")
    @JsonIgnore
    public Optional<String> getAuthenticationMethod() {
        return Optional.ofNullable(authenticationMethod);
    }

    public UserRegistrationMethodCount withAuthenticationMethod(String authenticationMethod) {
        UserRegistrationMethodCount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userRegistrationMethodCount");
        _x.authenticationMethod = authenticationMethod;
        return _x;
    }

    @Property(name="userCount")
    @JsonIgnore
    public Optional<Long> getUserCount() {
        return Optional.ofNullable(userCount);
    }

    public UserRegistrationMethodCount withUserCount(Long userCount) {
        UserRegistrationMethodCount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userRegistrationMethodCount");
        _x.userCount = userCount;
        return _x;
    }

    public UserRegistrationMethodCount withUnmappedField(String name, Object value) {
        UserRegistrationMethodCount _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String authenticationMethod;
        private Long userCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder authenticationMethod(String authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            this.changedFields = changedFields.add("authenticationMethod");
            return this;
        }

        public Builder userCount(Long userCount) {
            this.userCount = userCount;
            this.changedFields = changedFields.add("userCount");
            return this;
        }

        public UserRegistrationMethodCount build() {
            UserRegistrationMethodCount _x = new UserRegistrationMethodCount();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userRegistrationMethodCount";
            _x.authenticationMethod = authenticationMethod;
            _x.userCount = userCount;
            return _x;
        }
    }

    private UserRegistrationMethodCount _copy() {
        UserRegistrationMethodCount _x = new UserRegistrationMethodCount();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.authenticationMethod = authenticationMethod;
        _x.userCount = userCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserRegistrationMethodCount[");
        b.append("authenticationMethod=");
        b.append(this.authenticationMethod);
        b.append(", ");
        b.append("userCount=");
        b.append(this.userCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
