package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.IncludedUserRoles;
import odata.msgraph.client.beta.enums.IncludedUserTypes;

@JsonPropertyOrder({
    "@odata.type", 
    "totalUserCount", 
    "userRegistrationFeatureCounts", 
    "userRoles", 
    "userTypes"})
@JsonInclude(Include.NON_NULL)
public class UserRegistrationFeatureSummary implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("totalUserCount")
    protected Long totalUserCount;

    @JsonProperty("userRegistrationFeatureCounts")
    protected List<UserRegistrationFeatureCount> userRegistrationFeatureCounts;

    @JsonProperty("userRegistrationFeatureCounts@nextLink")
    protected String userRegistrationFeatureCountsNextLink;

    @JsonProperty("userRoles")
    protected IncludedUserRoles userRoles;

    @JsonProperty("userTypes")
    protected IncludedUserTypes userTypes;

    protected UserRegistrationFeatureSummary() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userRegistrationFeatureSummary";
    }

    @Property(name="totalUserCount")
    @JsonIgnore
    public Optional<Long> getTotalUserCount() {
        return Optional.ofNullable(totalUserCount);
    }

    public UserRegistrationFeatureSummary withTotalUserCount(Long totalUserCount) {
        UserRegistrationFeatureSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userRegistrationFeatureSummary");
        _x.totalUserCount = totalUserCount;
        return _x;
    }

    @Property(name="userRegistrationFeatureCounts")
    @JsonIgnore
    public CollectionPage<UserRegistrationFeatureCount> getUserRegistrationFeatureCounts() {
        return new CollectionPage<UserRegistrationFeatureCount>(contextPath, UserRegistrationFeatureCount.class, this.userRegistrationFeatureCounts, Optional.ofNullable(userRegistrationFeatureCountsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="userRegistrationFeatureCounts")
    @JsonIgnore
    public CollectionPage<UserRegistrationFeatureCount> getUserRegistrationFeatureCounts(HttpRequestOptions options) {
        return new CollectionPage<UserRegistrationFeatureCount>(contextPath, UserRegistrationFeatureCount.class, this.userRegistrationFeatureCounts, Optional.ofNullable(userRegistrationFeatureCountsNextLink), Collections.emptyList(), options);
    }

    @Property(name="userRoles")
    @JsonIgnore
    public Optional<IncludedUserRoles> getUserRoles() {
        return Optional.ofNullable(userRoles);
    }

    public UserRegistrationFeatureSummary withUserRoles(IncludedUserRoles userRoles) {
        UserRegistrationFeatureSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userRegistrationFeatureSummary");
        _x.userRoles = userRoles;
        return _x;
    }

    @Property(name="userTypes")
    @JsonIgnore
    public Optional<IncludedUserTypes> getUserTypes() {
        return Optional.ofNullable(userTypes);
    }

    public UserRegistrationFeatureSummary withUserTypes(IncludedUserTypes userTypes) {
        UserRegistrationFeatureSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userRegistrationFeatureSummary");
        _x.userTypes = userTypes;
        return _x;
    }

    public UserRegistrationFeatureSummary withUnmappedField(String name, Object value) {
        UserRegistrationFeatureSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Long totalUserCount;
        private List<UserRegistrationFeatureCount> userRegistrationFeatureCounts;
        private String userRegistrationFeatureCountsNextLink;
        private IncludedUserRoles userRoles;
        private IncludedUserTypes userTypes;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder totalUserCount(Long totalUserCount) {
            this.totalUserCount = totalUserCount;
            this.changedFields = changedFields.add("totalUserCount");
            return this;
        }

        public Builder userRegistrationFeatureCounts(List<UserRegistrationFeatureCount> userRegistrationFeatureCounts) {
            this.userRegistrationFeatureCounts = userRegistrationFeatureCounts;
            this.changedFields = changedFields.add("userRegistrationFeatureCounts");
            return this;
        }

        public Builder userRegistrationFeatureCounts(UserRegistrationFeatureCount... userRegistrationFeatureCounts) {
            return userRegistrationFeatureCounts(Arrays.asList(userRegistrationFeatureCounts));
        }

        public Builder userRegistrationFeatureCountsNextLink(String userRegistrationFeatureCountsNextLink) {
            this.userRegistrationFeatureCountsNextLink = userRegistrationFeatureCountsNextLink;
            this.changedFields = changedFields.add("userRegistrationFeatureCounts");
            return this;
        }

        public Builder userRoles(IncludedUserRoles userRoles) {
            this.userRoles = userRoles;
            this.changedFields = changedFields.add("userRoles");
            return this;
        }

        public Builder userTypes(IncludedUserTypes userTypes) {
            this.userTypes = userTypes;
            this.changedFields = changedFields.add("userTypes");
            return this;
        }

        public UserRegistrationFeatureSummary build() {
            UserRegistrationFeatureSummary _x = new UserRegistrationFeatureSummary();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userRegistrationFeatureSummary";
            _x.totalUserCount = totalUserCount;
            _x.userRegistrationFeatureCounts = userRegistrationFeatureCounts;
            _x.userRegistrationFeatureCountsNextLink = userRegistrationFeatureCountsNextLink;
            _x.userRoles = userRoles;
            _x.userTypes = userTypes;
            return _x;
        }
    }

    private UserRegistrationFeatureSummary _copy() {
        UserRegistrationFeatureSummary _x = new UserRegistrationFeatureSummary();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.totalUserCount = totalUserCount;
        _x.userRegistrationFeatureCounts = userRegistrationFeatureCounts;
        _x.userRoles = userRoles;
        _x.userTypes = userTypes;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserRegistrationFeatureSummary[");
        b.append("totalUserCount=");
        b.append(this.totalUserCount);
        b.append(", ");
        b.append("userRegistrationFeatureCounts=");
        b.append(this.userRegistrationFeatureCounts);
        b.append(", ");
        b.append("userRoles=");
        b.append(this.userRoles);
        b.append(", ");
        b.append("userTypes=");
        b.append(this.userTypes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
