package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.RegistrationStatusType;

@JsonPropertyOrder({
    "@odata.type", 
    "registrationCount", 
    "registrationStatus"})
@JsonInclude(Include.NON_NULL)
public class UserRegistrationCount implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("registrationCount")
    protected Long registrationCount;

    @JsonProperty("registrationStatus")
    protected RegistrationStatusType registrationStatus;

    protected UserRegistrationCount() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userRegistrationCount";
    }

    @Property(name="registrationCount")
    @JsonIgnore
    public Optional<Long> getRegistrationCount() {
        return Optional.ofNullable(registrationCount);
    }

    public UserRegistrationCount withRegistrationCount(Long registrationCount) {
        UserRegistrationCount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userRegistrationCount");
        _x.registrationCount = registrationCount;
        return _x;
    }

    @Property(name="registrationStatus")
    @JsonIgnore
    public Optional<RegistrationStatusType> getRegistrationStatus() {
        return Optional.ofNullable(registrationStatus);
    }

    public UserRegistrationCount withRegistrationStatus(RegistrationStatusType registrationStatus) {
        UserRegistrationCount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userRegistrationCount");
        _x.registrationStatus = registrationStatus;
        return _x;
    }

    public UserRegistrationCount withUnmappedField(String name, Object value) {
        UserRegistrationCount _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Long registrationCount;
        private RegistrationStatusType registrationStatus;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder registrationCount(Long registrationCount) {
            this.registrationCount = registrationCount;
            this.changedFields = changedFields.add("registrationCount");
            return this;
        }

        public Builder registrationStatus(RegistrationStatusType registrationStatus) {
            this.registrationStatus = registrationStatus;
            this.changedFields = changedFields.add("registrationStatus");
            return this;
        }

        public UserRegistrationCount build() {
            UserRegistrationCount _x = new UserRegistrationCount();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userRegistrationCount";
            _x.registrationCount = registrationCount;
            _x.registrationStatus = registrationStatus;
            return _x;
        }
    }

    private UserRegistrationCount _copy() {
        UserRegistrationCount _x = new UserRegistrationCount();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.registrationCount = registrationCount;
        _x.registrationStatus = registrationStatus;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserRegistrationCount[");
        b.append("registrationCount=");
        b.append(this.registrationCount);
        b.append(", ");
        b.append("registrationStatus=");
        b.append(this.registrationStatus);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
