package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.Duration;
import java.util.Optional;

import odata.msgraph.client.beta.enums.UserSignInRecommendationScope;

@JsonPropertyOrder({
    "@odata.type", 
    "recommendationLookBackDuration", 
    "signInScope"})
@JsonInclude(Include.NON_NULL)
public class UserLastSignInRecommendationInsightSetting extends AccessReviewRecommendationInsightSetting implements ODataType {

    @JsonProperty("recommendationLookBackDuration")
    protected Duration recommendationLookBackDuration;

    @JsonProperty("signInScope")
    protected UserSignInRecommendationScope signInScope;

    protected UserLastSignInRecommendationInsightSetting() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userLastSignInRecommendationInsightSetting";
    }

    @Property(name="recommendationLookBackDuration")
    @JsonIgnore
    public Optional<Duration> getRecommendationLookBackDuration() {
        return Optional.ofNullable(recommendationLookBackDuration);
    }

    public UserLastSignInRecommendationInsightSetting withRecommendationLookBackDuration(Duration recommendationLookBackDuration) {
        UserLastSignInRecommendationInsightSetting _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userLastSignInRecommendationInsightSetting");
        _x.recommendationLookBackDuration = recommendationLookBackDuration;
        return _x;
    }

    @Property(name="signInScope")
    @JsonIgnore
    public Optional<UserSignInRecommendationScope> getSignInScope() {
        return Optional.ofNullable(signInScope);
    }

    public UserLastSignInRecommendationInsightSetting withSignInScope(UserSignInRecommendationScope signInScope) {
        UserLastSignInRecommendationInsightSetting _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userLastSignInRecommendationInsightSetting");
        _x.signInScope = signInScope;
        return _x;
    }

    public UserLastSignInRecommendationInsightSetting withUnmappedField(String name, Object value) {
        UserLastSignInRecommendationInsightSetting _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserLastSignInRecommendationInsightSetting() {
        return new Builder();
    }

    public static final class Builder {
        private Duration recommendationLookBackDuration;
        private UserSignInRecommendationScope signInScope;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder recommendationLookBackDuration(Duration recommendationLookBackDuration) {
            this.recommendationLookBackDuration = recommendationLookBackDuration;
            this.changedFields = changedFields.add("recommendationLookBackDuration");
            return this;
        }

        public Builder signInScope(UserSignInRecommendationScope signInScope) {
            this.signInScope = signInScope;
            this.changedFields = changedFields.add("signInScope");
            return this;
        }

        public UserLastSignInRecommendationInsightSetting build() {
            UserLastSignInRecommendationInsightSetting _x = new UserLastSignInRecommendationInsightSetting();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userLastSignInRecommendationInsightSetting";
            _x.recommendationLookBackDuration = recommendationLookBackDuration;
            _x.signInScope = signInScope;
            return _x;
        }
    }

    private UserLastSignInRecommendationInsightSetting _copy() {
        UserLastSignInRecommendationInsightSetting _x = new UserLastSignInRecommendationInsightSetting();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.recommendationLookBackDuration = recommendationLookBackDuration;
        _x.signInScope = signInScope;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserLastSignInRecommendationInsightSetting[");
        b.append("recommendationLookBackDuration=");
        b.append(this.recommendationLookBackDuration);
        b.append(", ");
        b.append("signInScope=");
        b.append(this.signInScope);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
