package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“The user experience analytics Work From Anywhere metrics devices summary.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "autopilotDevicesSummary", 
    "cloudIdentityDevicesSummary", 
    "cloudManagementDevicesSummary", 
    "coManagedDevices", 
    "devicesNotAutopilotRegistered", 
    "devicesWithoutAutopilotProfileAssigned", 
    "devicesWithoutCloudIdentity", 
    "intuneDevices", 
    "tenantAttachDevices", 
    "totalDevices", 
    "unsupportedOSversionDevices", 
    "windows10Devices", 
    "windows10DevicesSummary", 
    "windows10DevicesWithoutTenantAttach"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsWorkFromAnywhereDevicesSummary implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("autopilotDevicesSummary")
    protected UserExperienceAnalyticsAutopilotDevicesSummary autopilotDevicesSummary;

    @JsonProperty("cloudIdentityDevicesSummary")
    protected UserExperienceAnalyticsCloudIdentityDevicesSummary cloudIdentityDevicesSummary;

    @JsonProperty("cloudManagementDevicesSummary")
    protected UserExperienceAnalyticsCloudManagementDevicesSummary cloudManagementDevicesSummary;

    @JsonProperty("coManagedDevices")
    protected Integer coManagedDevices;

    @JsonProperty("devicesNotAutopilotRegistered")
    protected Integer devicesNotAutopilotRegistered;

    @JsonProperty("devicesWithoutAutopilotProfileAssigned")
    protected Integer devicesWithoutAutopilotProfileAssigned;

    @JsonProperty("devicesWithoutCloudIdentity")
    protected Integer devicesWithoutCloudIdentity;

    @JsonProperty("intuneDevices")
    protected Integer intuneDevices;

    @JsonProperty("tenantAttachDevices")
    protected Integer tenantAttachDevices;

    @JsonProperty("totalDevices")
    protected Integer totalDevices;

    @JsonProperty("unsupportedOSversionDevices")
    protected Integer unsupportedOSversionDevices;

    @JsonProperty("windows10Devices")
    protected Integer windows10Devices;

    @JsonProperty("windows10DevicesSummary")
    protected UserExperienceAnalyticsWindows10DevicesSummary windows10DevicesSummary;

    @JsonProperty("windows10DevicesWithoutTenantAttach")
    protected Integer windows10DevicesWithoutTenantAttach;

    protected UserExperienceAnalyticsWorkFromAnywhereDevicesSummary() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevicesSummary";
    }

    /**
     * <i>“The value of work from anywhere autopilot devices summary.”</i>
     * 
     * @return property autopilotDevicesSummary
     */
    @Property(name="autopilotDevicesSummary")
    @JsonIgnore
    public Optional<UserExperienceAnalyticsAutopilotDevicesSummary> getAutopilotDevicesSummary() {
        return Optional.ofNullable(autopilotDevicesSummary);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * autopilotDevicesSummary} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The value of work from anywhere autopilot devices summary.”</i>
     * 
     * @param autopilotDevicesSummary
     *            new value of {@code autopilotDevicesSummary} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code autopilotDevicesSummary} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevicesSummary withAutopilotDevicesSummary(UserExperienceAnalyticsAutopilotDevicesSummary autopilotDevicesSummary) {
        UserExperienceAnalyticsWorkFromAnywhereDevicesSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevicesSummary");
        _x.autopilotDevicesSummary = autopilotDevicesSummary;
        return _x;
    }

    /**
     * <i>“The user experience analytics work from anywhere Cloud Identity devices summary.”</i>
     * 
     * @return property cloudIdentityDevicesSummary
     */
    @Property(name="cloudIdentityDevicesSummary")
    @JsonIgnore
    public Optional<UserExperienceAnalyticsCloudIdentityDevicesSummary> getCloudIdentityDevicesSummary() {
        return Optional.ofNullable(cloudIdentityDevicesSummary);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cloudIdentityDevicesSummary} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The user experience analytics work from anywhere Cloud Identity devices summary.”</i>
     * 
     * @param cloudIdentityDevicesSummary
     *            new value of {@code cloudIdentityDevicesSummary} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cloudIdentityDevicesSummary} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevicesSummary withCloudIdentityDevicesSummary(UserExperienceAnalyticsCloudIdentityDevicesSummary cloudIdentityDevicesSummary) {
        UserExperienceAnalyticsWorkFromAnywhereDevicesSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevicesSummary");
        _x.cloudIdentityDevicesSummary = cloudIdentityDevicesSummary;
        return _x;
    }

    /**
     * <i>“The user experience work from anywhere Cloud management devices summary.”</i>
     * 
     * @return property cloudManagementDevicesSummary
     */
    @Property(name="cloudManagementDevicesSummary")
    @JsonIgnore
    public Optional<UserExperienceAnalyticsCloudManagementDevicesSummary> getCloudManagementDevicesSummary() {
        return Optional.ofNullable(cloudManagementDevicesSummary);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cloudManagementDevicesSummary} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The user experience work from anywhere Cloud management devices summary.”</i>
     * 
     * @param cloudManagementDevicesSummary
     *            new value of {@code cloudManagementDevicesSummary} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cloudManagementDevicesSummary} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevicesSummary withCloudManagementDevicesSummary(UserExperienceAnalyticsCloudManagementDevicesSummary cloudManagementDevicesSummary) {
        UserExperienceAnalyticsWorkFromAnywhereDevicesSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevicesSummary");
        _x.cloudManagementDevicesSummary = cloudManagementDevicesSummary;
        return _x;
    }

    /**
     * <i>“Total number of co-managed devices. Valid values -2147483648 to 2147483647”</i>
     * 
     * @return property coManagedDevices
     */
    @Property(name="coManagedDevices")
    @JsonIgnore
    public Optional<Integer> getCoManagedDevices() {
        return Optional.ofNullable(coManagedDevices);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code coManagedDevices}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Total number of co-managed devices. Valid values -2147483648 to 2147483647”</i>
     * 
     * @param coManagedDevices
     *            new value of {@code coManagedDevices} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code coManagedDevices} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevicesSummary withCoManagedDevices(Integer coManagedDevices) {
        UserExperienceAnalyticsWorkFromAnywhereDevicesSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevicesSummary");
        _x.coManagedDevices = coManagedDevices;
        return _x;
    }

    /**
     * <i>“The count of intune devices that are not autopilot registerd. Valid values -
     * 2147483648 to 2147483647”</i>
     * 
     * @return property devicesNotAutopilotRegistered
     */
    @Property(name="devicesNotAutopilotRegistered")
    @JsonIgnore
    public Optional<Integer> getDevicesNotAutopilotRegistered() {
        return Optional.ofNullable(devicesNotAutopilotRegistered);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * devicesNotAutopilotRegistered} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The count of intune devices that are not autopilot registerd. Valid values -
     * 2147483648 to 2147483647”</i>
     * 
     * @param devicesNotAutopilotRegistered
     *            new value of {@code devicesNotAutopilotRegistered} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code devicesNotAutopilotRegistered} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevicesSummary withDevicesNotAutopilotRegistered(Integer devicesNotAutopilotRegistered) {
        UserExperienceAnalyticsWorkFromAnywhereDevicesSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevicesSummary");
        _x.devicesNotAutopilotRegistered = devicesNotAutopilotRegistered;
        return _x;
    }

    /**
     * <i>“The count of intune devices not autopilot profile assigned. Valid values -
     * 2147483648 to 2147483647”</i>
     * 
     * @return property devicesWithoutAutopilotProfileAssigned
     */
    @Property(name="devicesWithoutAutopilotProfileAssigned")
    @JsonIgnore
    public Optional<Integer> getDevicesWithoutAutopilotProfileAssigned() {
        return Optional.ofNullable(devicesWithoutAutopilotProfileAssigned);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * devicesWithoutAutopilotProfileAssigned} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The count of intune devices not autopilot profile assigned. Valid values -
     * 2147483648 to 2147483647”</i>
     * 
     * @param devicesWithoutAutopilotProfileAssigned
     *            new value of {@code devicesWithoutAutopilotProfileAssigned} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code devicesWithoutAutopilotProfileAssigned} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevicesSummary withDevicesWithoutAutopilotProfileAssigned(Integer devicesWithoutAutopilotProfileAssigned) {
        UserExperienceAnalyticsWorkFromAnywhereDevicesSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevicesSummary");
        _x.devicesWithoutAutopilotProfileAssigned = devicesWithoutAutopilotProfileAssigned;
        return _x;
    }

    /**
     * <i>“The count of devices that are not cloud identity. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @return property devicesWithoutCloudIdentity
     */
    @Property(name="devicesWithoutCloudIdentity")
    @JsonIgnore
    public Optional<Integer> getDevicesWithoutCloudIdentity() {
        return Optional.ofNullable(devicesWithoutCloudIdentity);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * devicesWithoutCloudIdentity} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The count of devices that are not cloud identity. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @param devicesWithoutCloudIdentity
     *            new value of {@code devicesWithoutCloudIdentity} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code devicesWithoutCloudIdentity} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevicesSummary withDevicesWithoutCloudIdentity(Integer devicesWithoutCloudIdentity) {
        UserExperienceAnalyticsWorkFromAnywhereDevicesSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevicesSummary");
        _x.devicesWithoutCloudIdentity = devicesWithoutCloudIdentity;
        return _x;
    }

    /**
     * <i>“The count of intune devices that are not autopilot registerd. Valid values -
     * 2147483648 to 2147483647”</i>
     * 
     * @return property intuneDevices
     */
    @Property(name="intuneDevices")
    @JsonIgnore
    public Optional<Integer> getIntuneDevices() {
        return Optional.ofNullable(intuneDevices);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code intuneDevices}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The count of intune devices that are not autopilot registerd. Valid values -
     * 2147483648 to 2147483647”</i>
     * 
     * @param intuneDevices
     *            new value of {@code intuneDevices} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code intuneDevices} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevicesSummary withIntuneDevices(Integer intuneDevices) {
        UserExperienceAnalyticsWorkFromAnywhereDevicesSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevicesSummary");
        _x.intuneDevices = intuneDevices;
        return _x;
    }

    /**
     * <i>“Total count of tenant attach devices. Valid values -2147483648 to 2147483647”</i>
     * 
     * @return property tenantAttachDevices
     */
    @Property(name="tenantAttachDevices")
    @JsonIgnore
    public Optional<Integer> getTenantAttachDevices() {
        return Optional.ofNullable(tenantAttachDevices);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * tenantAttachDevices} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Total count of tenant attach devices. Valid values -2147483648 to 2147483647”</i>
     * 
     * @param tenantAttachDevices
     *            new value of {@code tenantAttachDevices} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code tenantAttachDevices} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevicesSummary withTenantAttachDevices(Integer tenantAttachDevices) {
        UserExperienceAnalyticsWorkFromAnywhereDevicesSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevicesSummary");
        _x.tenantAttachDevices = tenantAttachDevices;
        return _x;
    }

    /**
     * <i>“The total count of devices. Valid values -2147483648 to 2147483647”</i>
     * 
     * @return property totalDevices
     */
    @Property(name="totalDevices")
    @JsonIgnore
    public Optional<Integer> getTotalDevices() {
        return Optional.ofNullable(totalDevices);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code totalDevices}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The total count of devices. Valid values -2147483648 to 2147483647”</i>
     * 
     * @param totalDevices
     *            new value of {@code totalDevices} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code totalDevices} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevicesSummary withTotalDevices(Integer totalDevices) {
        UserExperienceAnalyticsWorkFromAnywhereDevicesSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevicesSummary");
        _x.totalDevices = totalDevices;
        return _x;
    }

    /**
     * <i>“The count of Windows 10 devices that have unsupported OS versions. Valid values
     * -2147483648 to 2147483647”</i>
     * 
     * @return property unsupportedOSversionDevices
     */
    @Property(name="unsupportedOSversionDevices")
    @JsonIgnore
    public Optional<Integer> getUnsupportedOSversionDevices() {
        return Optional.ofNullable(unsupportedOSversionDevices);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * unsupportedOSversionDevices} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The count of Windows 10 devices that have unsupported OS versions. Valid values
     * -2147483648 to 2147483647”</i>
     * 
     * @param unsupportedOSversionDevices
     *            new value of {@code unsupportedOSversionDevices} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code unsupportedOSversionDevices} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevicesSummary withUnsupportedOSversionDevices(Integer unsupportedOSversionDevices) {
        UserExperienceAnalyticsWorkFromAnywhereDevicesSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevicesSummary");
        _x.unsupportedOSversionDevices = unsupportedOSversionDevices;
        return _x;
    }

    /**
     * <i>“The count of windows 10 devices. Valid values -2147483648 to 2147483647”</i>
     * 
     * @return property windows10Devices
     */
    @Property(name="windows10Devices")
    @JsonIgnore
    public Optional<Integer> getWindows10Devices() {
        return Optional.ofNullable(windows10Devices);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code windows10Devices}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The count of windows 10 devices. Valid values -2147483648 to 2147483647”</i>
     * 
     * @param windows10Devices
     *            new value of {@code windows10Devices} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windows10Devices} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevicesSummary withWindows10Devices(Integer windows10Devices) {
        UserExperienceAnalyticsWorkFromAnywhereDevicesSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevicesSummary");
        _x.windows10Devices = windows10Devices;
        return _x;
    }

    /**
     * <i>“The user experience analytics work from anywhere Windows 10 devices summary.”</i>
     * 
     * @return property windows10DevicesSummary
     */
    @Property(name="windows10DevicesSummary")
    @JsonIgnore
    public Optional<UserExperienceAnalyticsWindows10DevicesSummary> getWindows10DevicesSummary() {
        return Optional.ofNullable(windows10DevicesSummary);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windows10DevicesSummary} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The user experience analytics work from anywhere Windows 10 devices summary.”</i>
     * 
     * @param windows10DevicesSummary
     *            new value of {@code windows10DevicesSummary} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windows10DevicesSummary} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevicesSummary withWindows10DevicesSummary(UserExperienceAnalyticsWindows10DevicesSummary windows10DevicesSummary) {
        UserExperienceAnalyticsWorkFromAnywhereDevicesSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevicesSummary");
        _x.windows10DevicesSummary = windows10DevicesSummary;
        return _x;
    }

    /**
     * <i>“The count of windows 10 devices that are Intune and Comanaged. Valid values -
     * 2147483648 to 2147483647”</i>
     * 
     * @return property windows10DevicesWithoutTenantAttach
     */
    @Property(name="windows10DevicesWithoutTenantAttach")
    @JsonIgnore
    public Optional<Integer> getWindows10DevicesWithoutTenantAttach() {
        return Optional.ofNullable(windows10DevicesWithoutTenantAttach);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windows10DevicesWithoutTenantAttach} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The count of windows 10 devices that are Intune and Comanaged. Valid values -
     * 2147483648 to 2147483647”</i>
     * 
     * @param windows10DevicesWithoutTenantAttach
     *            new value of {@code windows10DevicesWithoutTenantAttach} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windows10DevicesWithoutTenantAttach} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereDevicesSummary withWindows10DevicesWithoutTenantAttach(Integer windows10DevicesWithoutTenantAttach) {
        UserExperienceAnalyticsWorkFromAnywhereDevicesSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevicesSummary");
        _x.windows10DevicesWithoutTenantAttach = windows10DevicesWithoutTenantAttach;
        return _x;
    }

    public UserExperienceAnalyticsWorkFromAnywhereDevicesSummary withUnmappedField(String name, Object value) {
        UserExperienceAnalyticsWorkFromAnywhereDevicesSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private UserExperienceAnalyticsAutopilotDevicesSummary autopilotDevicesSummary;
        private UserExperienceAnalyticsCloudIdentityDevicesSummary cloudIdentityDevicesSummary;
        private UserExperienceAnalyticsCloudManagementDevicesSummary cloudManagementDevicesSummary;
        private Integer coManagedDevices;
        private Integer devicesNotAutopilotRegistered;
        private Integer devicesWithoutAutopilotProfileAssigned;
        private Integer devicesWithoutCloudIdentity;
        private Integer intuneDevices;
        private Integer tenantAttachDevices;
        private Integer totalDevices;
        private Integer unsupportedOSversionDevices;
        private Integer windows10Devices;
        private UserExperienceAnalyticsWindows10DevicesSummary windows10DevicesSummary;
        private Integer windows10DevicesWithoutTenantAttach;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The value of work from anywhere autopilot devices summary.”</i>
         * 
         * @param autopilotDevicesSummary
         *            value of {@code autopilotDevicesSummary} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder autopilotDevicesSummary(UserExperienceAnalyticsAutopilotDevicesSummary autopilotDevicesSummary) {
            this.autopilotDevicesSummary = autopilotDevicesSummary;
            this.changedFields = changedFields.add("autopilotDevicesSummary");
            return this;
        }

        /**
         * <i>“The user experience analytics work from anywhere Cloud Identity devices summary.”</i>
         * 
         * @param cloudIdentityDevicesSummary
         *            value of {@code cloudIdentityDevicesSummary} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cloudIdentityDevicesSummary(UserExperienceAnalyticsCloudIdentityDevicesSummary cloudIdentityDevicesSummary) {
            this.cloudIdentityDevicesSummary = cloudIdentityDevicesSummary;
            this.changedFields = changedFields.add("cloudIdentityDevicesSummary");
            return this;
        }

        /**
         * <i>“The user experience work from anywhere Cloud management devices summary.”</i>
         * 
         * @param cloudManagementDevicesSummary
         *            value of {@code cloudManagementDevicesSummary} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cloudManagementDevicesSummary(UserExperienceAnalyticsCloudManagementDevicesSummary cloudManagementDevicesSummary) {
            this.cloudManagementDevicesSummary = cloudManagementDevicesSummary;
            this.changedFields = changedFields.add("cloudManagementDevicesSummary");
            return this;
        }

        /**
         * <i>“Total number of co-managed devices. Valid values -2147483648 to 2147483647”</i>
         * 
         * @param coManagedDevices
         *            value of {@code coManagedDevices} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder coManagedDevices(Integer coManagedDevices) {
            this.coManagedDevices = coManagedDevices;
            this.changedFields = changedFields.add("coManagedDevices");
            return this;
        }

        /**
         * <i>“The count of intune devices that are not autopilot registerd. Valid values -
         * 2147483648 to 2147483647”</i>
         * 
         * @param devicesNotAutopilotRegistered
         *            value of {@code devicesNotAutopilotRegistered} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder devicesNotAutopilotRegistered(Integer devicesNotAutopilotRegistered) {
            this.devicesNotAutopilotRegistered = devicesNotAutopilotRegistered;
            this.changedFields = changedFields.add("devicesNotAutopilotRegistered");
            return this;
        }

        /**
         * <i>“The count of intune devices not autopilot profile assigned. Valid values -
         * 2147483648 to 2147483647”</i>
         * 
         * @param devicesWithoutAutopilotProfileAssigned
         *            value of {@code devicesWithoutAutopilotProfileAssigned} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder devicesWithoutAutopilotProfileAssigned(Integer devicesWithoutAutopilotProfileAssigned) {
            this.devicesWithoutAutopilotProfileAssigned = devicesWithoutAutopilotProfileAssigned;
            this.changedFields = changedFields.add("devicesWithoutAutopilotProfileAssigned");
            return this;
        }

        /**
         * <i>“The count of devices that are not cloud identity. Valid values -2147483648 to
         * 2147483647”</i>
         * 
         * @param devicesWithoutCloudIdentity
         *            value of {@code devicesWithoutCloudIdentity} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder devicesWithoutCloudIdentity(Integer devicesWithoutCloudIdentity) {
            this.devicesWithoutCloudIdentity = devicesWithoutCloudIdentity;
            this.changedFields = changedFields.add("devicesWithoutCloudIdentity");
            return this;
        }

        /**
         * <i>“The count of intune devices that are not autopilot registerd. Valid values -
         * 2147483648 to 2147483647”</i>
         * 
         * @param intuneDevices
         *            value of {@code intuneDevices} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder intuneDevices(Integer intuneDevices) {
            this.intuneDevices = intuneDevices;
            this.changedFields = changedFields.add("intuneDevices");
            return this;
        }

        /**
         * <i>“Total count of tenant attach devices. Valid values -2147483648 to 2147483647”</i>
         * 
         * @param tenantAttachDevices
         *            value of {@code tenantAttachDevices} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tenantAttachDevices(Integer tenantAttachDevices) {
            this.tenantAttachDevices = tenantAttachDevices;
            this.changedFields = changedFields.add("tenantAttachDevices");
            return this;
        }

        /**
         * <i>“The total count of devices. Valid values -2147483648 to 2147483647”</i>
         * 
         * @param totalDevices
         *            value of {@code totalDevices} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder totalDevices(Integer totalDevices) {
            this.totalDevices = totalDevices;
            this.changedFields = changedFields.add("totalDevices");
            return this;
        }

        /**
         * <i>“The count of Windows 10 devices that have unsupported OS versions. Valid values
         * -2147483648 to 2147483647”</i>
         * 
         * @param unsupportedOSversionDevices
         *            value of {@code unsupportedOSversionDevices} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder unsupportedOSversionDevices(Integer unsupportedOSversionDevices) {
            this.unsupportedOSversionDevices = unsupportedOSversionDevices;
            this.changedFields = changedFields.add("unsupportedOSversionDevices");
            return this;
        }

        /**
         * <i>“The count of windows 10 devices. Valid values -2147483648 to 2147483647”</i>
         * 
         * @param windows10Devices
         *            value of {@code windows10Devices} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windows10Devices(Integer windows10Devices) {
            this.windows10Devices = windows10Devices;
            this.changedFields = changedFields.add("windows10Devices");
            return this;
        }

        /**
         * <i>“The user experience analytics work from anywhere Windows 10 devices summary.”</i>
         * 
         * @param windows10DevicesSummary
         *            value of {@code windows10DevicesSummary} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windows10DevicesSummary(UserExperienceAnalyticsWindows10DevicesSummary windows10DevicesSummary) {
            this.windows10DevicesSummary = windows10DevicesSummary;
            this.changedFields = changedFields.add("windows10DevicesSummary");
            return this;
        }

        /**
         * <i>“The count of windows 10 devices that are Intune and Comanaged. Valid values -
         * 2147483648 to 2147483647”</i>
         * 
         * @param windows10DevicesWithoutTenantAttach
         *            value of {@code windows10DevicesWithoutTenantAttach} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windows10DevicesWithoutTenantAttach(Integer windows10DevicesWithoutTenantAttach) {
            this.windows10DevicesWithoutTenantAttach = windows10DevicesWithoutTenantAttach;
            this.changedFields = changedFields.add("windows10DevicesWithoutTenantAttach");
            return this;
        }

        public UserExperienceAnalyticsWorkFromAnywhereDevicesSummary build() {
            UserExperienceAnalyticsWorkFromAnywhereDevicesSummary _x = new UserExperienceAnalyticsWorkFromAnywhereDevicesSummary();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereDevicesSummary";
            _x.autopilotDevicesSummary = autopilotDevicesSummary;
            _x.cloudIdentityDevicesSummary = cloudIdentityDevicesSummary;
            _x.cloudManagementDevicesSummary = cloudManagementDevicesSummary;
            _x.coManagedDevices = coManagedDevices;
            _x.devicesNotAutopilotRegistered = devicesNotAutopilotRegistered;
            _x.devicesWithoutAutopilotProfileAssigned = devicesWithoutAutopilotProfileAssigned;
            _x.devicesWithoutCloudIdentity = devicesWithoutCloudIdentity;
            _x.intuneDevices = intuneDevices;
            _x.tenantAttachDevices = tenantAttachDevices;
            _x.totalDevices = totalDevices;
            _x.unsupportedOSversionDevices = unsupportedOSversionDevices;
            _x.windows10Devices = windows10Devices;
            _x.windows10DevicesSummary = windows10DevicesSummary;
            _x.windows10DevicesWithoutTenantAttach = windows10DevicesWithoutTenantAttach;
            return _x;
        }
    }

    private UserExperienceAnalyticsWorkFromAnywhereDevicesSummary _copy() {
        UserExperienceAnalyticsWorkFromAnywhereDevicesSummary _x = new UserExperienceAnalyticsWorkFromAnywhereDevicesSummary();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.autopilotDevicesSummary = autopilotDevicesSummary;
        _x.cloudIdentityDevicesSummary = cloudIdentityDevicesSummary;
        _x.cloudManagementDevicesSummary = cloudManagementDevicesSummary;
        _x.coManagedDevices = coManagedDevices;
        _x.devicesNotAutopilotRegistered = devicesNotAutopilotRegistered;
        _x.devicesWithoutAutopilotProfileAssigned = devicesWithoutAutopilotProfileAssigned;
        _x.devicesWithoutCloudIdentity = devicesWithoutCloudIdentity;
        _x.intuneDevices = intuneDevices;
        _x.tenantAttachDevices = tenantAttachDevices;
        _x.totalDevices = totalDevices;
        _x.unsupportedOSversionDevices = unsupportedOSversionDevices;
        _x.windows10Devices = windows10Devices;
        _x.windows10DevicesSummary = windows10DevicesSummary;
        _x.windows10DevicesWithoutTenantAttach = windows10DevicesWithoutTenantAttach;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsWorkFromAnywhereDevicesSummary[");
        b.append("autopilotDevicesSummary=");
        b.append(this.autopilotDevicesSummary);
        b.append(", ");
        b.append("cloudIdentityDevicesSummary=");
        b.append(this.cloudIdentityDevicesSummary);
        b.append(", ");
        b.append("cloudManagementDevicesSummary=");
        b.append(this.cloudManagementDevicesSummary);
        b.append(", ");
        b.append("coManagedDevices=");
        b.append(this.coManagedDevices);
        b.append(", ");
        b.append("devicesNotAutopilotRegistered=");
        b.append(this.devicesNotAutopilotRegistered);
        b.append(", ");
        b.append("devicesWithoutAutopilotProfileAssigned=");
        b.append(this.devicesWithoutAutopilotProfileAssigned);
        b.append(", ");
        b.append("devicesWithoutCloudIdentity=");
        b.append(this.devicesWithoutCloudIdentity);
        b.append(", ");
        b.append("intuneDevices=");
        b.append(this.intuneDevices);
        b.append(", ");
        b.append("tenantAttachDevices=");
        b.append(this.tenantAttachDevices);
        b.append(", ");
        b.append("totalDevices=");
        b.append(this.totalDevices);
        b.append(", ");
        b.append("unsupportedOSversionDevices=");
        b.append(this.unsupportedOSversionDevices);
        b.append(", ");
        b.append("windows10Devices=");
        b.append(this.windows10Devices);
        b.append(", ");
        b.append("windows10DevicesSummary=");
        b.append(this.windows10DevicesSummary);
        b.append(", ");
        b.append("windows10DevicesWithoutTenantAttach=");
        b.append(this.windows10DevicesWithoutTenantAttach);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
