package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpMethod;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Path;
import com.github.davidmoten.odata.client.StreamUploader;
import com.github.davidmoten.odata.client.StreamUploaderChunked;
import com.github.davidmoten.odata.client.StreamUploaderSingleCall;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.UploadStrategy;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "expirationDateTime", 
    "nextExpectedRanges", 
    "uploadUrl"})
@JsonInclude(Include.NON_NULL)
public class UploadSession implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("expirationDateTime")
    protected OffsetDateTime expirationDateTime;

    @JsonProperty("nextExpectedRanges")
    protected List<String> nextExpectedRanges;

    @JsonProperty("nextExpectedRanges@nextLink")
    protected String nextExpectedRangesNextLink;

    @JsonProperty("uploadUrl")
    protected String uploadUrl;

    protected UploadSession() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.uploadSession";
    }

    @Property(name="expirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpirationDateTime() {
        return Optional.ofNullable(expirationDateTime);
    }

    public UploadSession withExpirationDateTime(OffsetDateTime expirationDateTime) {
        UploadSession _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.uploadSession");
        _x.expirationDateTime = expirationDateTime;
        return _x;
    }

    @Property(name="nextExpectedRanges")
    @JsonIgnore
    public CollectionPage<String> getNextExpectedRanges() {
        return new CollectionPage<String>(contextPath, String.class, this.nextExpectedRanges, Optional.ofNullable(nextExpectedRangesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="nextExpectedRanges")
    @JsonIgnore
    public CollectionPage<String> getNextExpectedRanges(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.nextExpectedRanges, Optional.ofNullable(nextExpectedRangesNextLink), Collections.emptyList(), options);
    }

    @Property(name="uploadUrl")
    @JsonIgnore
    public Optional<String> getUploadUrl() {
        return Optional.ofNullable(uploadUrl);
    }

    public UploadSession withUploadUrl(String uploadUrl) {
        UploadSession _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.uploadSession");
        _x.uploadUrl = uploadUrl;
        return _x;
    }

    @Property(name="uploadUrl")
    public <T extends StreamUploader<T>> T put(UploadStrategy<T> strategy) {
        this.unmappedFields.put("uploadUrl@odata.mediaEditLink", uploadUrl);
        return strategy.builder(new ContextPath(contextPath.context(), new Path(uploadUrl, contextPath.context().service().getBasePath().style())), this, "uploadUrl", HttpMethod.PUT).get();
    }

    @Property(name="uploadUrl")
    public StreamUploaderChunked putChunked() {
        return put(UploadStrategy.chunked());
    }

    @Property(name="uploadUrl")
    public StreamUploaderSingleCall put() {
        return put(UploadStrategy.singleCall());
    }

    public UploadSession withUnmappedField(String name, Object value) {
        UploadSession _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime expirationDateTime;
        private List<String> nextExpectedRanges;
        private String nextExpectedRangesNextLink;
        private String uploadUrl;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder expirationDateTime(OffsetDateTime expirationDateTime) {
            this.expirationDateTime = expirationDateTime;
            this.changedFields = changedFields.add("expirationDateTime");
            return this;
        }

        public Builder nextExpectedRanges(List<String> nextExpectedRanges) {
            this.nextExpectedRanges = nextExpectedRanges;
            this.changedFields = changedFields.add("nextExpectedRanges");
            return this;
        }

        public Builder nextExpectedRanges(String... nextExpectedRanges) {
            return nextExpectedRanges(Arrays.asList(nextExpectedRanges));
        }

        public Builder nextExpectedRangesNextLink(String nextExpectedRangesNextLink) {
            this.nextExpectedRangesNextLink = nextExpectedRangesNextLink;
            this.changedFields = changedFields.add("nextExpectedRanges");
            return this;
        }

        public Builder uploadUrl(String uploadUrl) {
            this.uploadUrl = uploadUrl;
            this.changedFields = changedFields.add("uploadUrl");
            return this;
        }

        public UploadSession build() {
            UploadSession _x = new UploadSession();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.uploadSession";
            _x.expirationDateTime = expirationDateTime;
            _x.nextExpectedRanges = nextExpectedRanges;
            _x.nextExpectedRangesNextLink = nextExpectedRangesNextLink;
            _x.uploadUrl = uploadUrl;
            return _x;
        }
    }

    private UploadSession _copy() {
        UploadSession _x = new UploadSession();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.expirationDateTime = expirationDateTime;
        _x.nextExpectedRanges = nextExpectedRanges;
        _x.uploadUrl = uploadUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UploadSession[");
        b.append("expirationDateTime=");
        b.append(this.expirationDateTime);
        b.append(", ");
        b.append("nextExpectedRanges=");
        b.append(this.nextExpectedRanges);
        b.append(", ");
        b.append("uploadUrl=");
        b.append(this.uploadUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
