package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.LocalTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "updateWindowEndTime", 
    "updateWindowStartTime"})
@JsonInclude(Include.NON_NULL)
public class UpdateWindow implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("updateWindowEndTime")
    protected LocalTime updateWindowEndTime;

    @JsonProperty("updateWindowStartTime")
    protected LocalTime updateWindowStartTime;

    protected UpdateWindow() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.updateWindow";
    }

    @Property(name="updateWindowEndTime")
    @JsonIgnore
    public Optional<LocalTime> getUpdateWindowEndTime() {
        return Optional.ofNullable(updateWindowEndTime);
    }

    public UpdateWindow withUpdateWindowEndTime(LocalTime updateWindowEndTime) {
        UpdateWindow _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.updateWindow");
        _x.updateWindowEndTime = updateWindowEndTime;
        return _x;
    }

    @Property(name="updateWindowStartTime")
    @JsonIgnore
    public Optional<LocalTime> getUpdateWindowStartTime() {
        return Optional.ofNullable(updateWindowStartTime);
    }

    public UpdateWindow withUpdateWindowStartTime(LocalTime updateWindowStartTime) {
        UpdateWindow _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.updateWindow");
        _x.updateWindowStartTime = updateWindowStartTime;
        return _x;
    }

    public UpdateWindow withUnmappedField(String name, Object value) {
        UpdateWindow _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private LocalTime updateWindowEndTime;
        private LocalTime updateWindowStartTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder updateWindowEndTime(LocalTime updateWindowEndTime) {
            this.updateWindowEndTime = updateWindowEndTime;
            this.changedFields = changedFields.add("updateWindowEndTime");
            return this;
        }

        public Builder updateWindowStartTime(LocalTime updateWindowStartTime) {
            this.updateWindowStartTime = updateWindowStartTime;
            this.changedFields = changedFields.add("updateWindowStartTime");
            return this;
        }

        public UpdateWindow build() {
            UpdateWindow _x = new UpdateWindow();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.updateWindow";
            _x.updateWindowEndTime = updateWindowEndTime;
            _x.updateWindowStartTime = updateWindowStartTime;
            return _x;
        }
    }

    private UpdateWindow _copy() {
        UpdateWindow _x = new UpdateWindow();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.updateWindowEndTime = updateWindowEndTime;
        _x.updateWindowStartTime = updateWindowStartTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UpdateWindow[");
        b.append("updateWindowEndTime=");
        b.append(this.updateWindowEndTime);
        b.append(", ");
        b.append("updateWindowStartTime=");
        b.append(this.updateWindowStartTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
