package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.EmailType;

@JsonPropertyOrder({
    "@odata.type", 
    "otherLabel", 
    "type"})
@JsonInclude(Include.NON_NULL)
public class TypedEmailAddress extends EmailAddress implements ODataType {

    @JsonProperty("otherLabel")
    protected String otherLabel;

    @JsonProperty("type")
    protected EmailType type;

    protected TypedEmailAddress() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.typedEmailAddress";
    }

    @Property(name="otherLabel")
    @JsonIgnore
    public Optional<String> getOtherLabel() {
        return Optional.ofNullable(otherLabel);
    }

    public TypedEmailAddress withOtherLabel(String otherLabel) {
        TypedEmailAddress _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.typedEmailAddress");
        _x.otherLabel = otherLabel;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<EmailType> getType() {
        return Optional.ofNullable(type);
    }

    public TypedEmailAddress withType(EmailType type) {
        TypedEmailAddress _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.typedEmailAddress");
        _x.type = type;
        return _x;
    }

    public TypedEmailAddress withUnmappedField(String name, Object value) {
        TypedEmailAddress _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTypedEmailAddress() {
        return new Builder();
    }

    public static final class Builder {
        private String address;
        private String name;
        private String otherLabel;
        private EmailType type;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder address(String address) {
            this.address = address;
            this.changedFields = changedFields.add("address");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder otherLabel(String otherLabel) {
            this.otherLabel = otherLabel;
            this.changedFields = changedFields.add("otherLabel");
            return this;
        }

        public Builder type(EmailType type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public TypedEmailAddress build() {
            TypedEmailAddress _x = new TypedEmailAddress();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.typedEmailAddress";
            _x.address = address;
            _x.name = name;
            _x.otherLabel = otherLabel;
            _x.type = type;
            return _x;
        }
    }

    private TypedEmailAddress _copy() {
        TypedEmailAddress _x = new TypedEmailAddress();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.address = address;
        _x.name = name;
        _x.otherLabel = otherLabel;
        _x.type = type;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TypedEmailAddress[");
        b.append("address=");
        b.append(this.address);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("otherLabel=");
        b.append(this.otherLabel);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
