package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.TranslationBehavior;

@JsonPropertyOrder({
    "@odata.type", 
    "languageTag", 
    "translationBehavior"})
@JsonInclude(Include.NON_NULL)
public class TranslationLanguageOverride implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("languageTag")
    protected String languageTag;

    @JsonProperty("translationBehavior")
    protected TranslationBehavior translationBehavior;

    protected TranslationLanguageOverride() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.translationLanguageOverride";
    }

    @Property(name="languageTag")
    @JsonIgnore
    public Optional<String> getLanguageTag() {
        return Optional.ofNullable(languageTag);
    }

    public TranslationLanguageOverride withLanguageTag(String languageTag) {
        TranslationLanguageOverride _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.translationLanguageOverride");
        _x.languageTag = languageTag;
        return _x;
    }

    @Property(name="translationBehavior")
    @JsonIgnore
    public Optional<TranslationBehavior> getTranslationBehavior() {
        return Optional.ofNullable(translationBehavior);
    }

    public TranslationLanguageOverride withTranslationBehavior(TranslationBehavior translationBehavior) {
        TranslationLanguageOverride _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.translationLanguageOverride");
        _x.translationBehavior = translationBehavior;
        return _x;
    }

    public TranslationLanguageOverride withUnmappedField(String name, Object value) {
        TranslationLanguageOverride _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String languageTag;
        private TranslationBehavior translationBehavior;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder languageTag(String languageTag) {
            this.languageTag = languageTag;
            this.changedFields = changedFields.add("languageTag");
            return this;
        }

        public Builder translationBehavior(TranslationBehavior translationBehavior) {
            this.translationBehavior = translationBehavior;
            this.changedFields = changedFields.add("translationBehavior");
            return this;
        }

        public TranslationLanguageOverride build() {
            TranslationLanguageOverride _x = new TranslationLanguageOverride();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.translationLanguageOverride";
            _x.languageTag = languageTag;
            _x.translationBehavior = translationBehavior;
            return _x;
        }
    }

    private TranslationLanguageOverride _copy() {
        TranslationLanguageOverride _x = new TranslationLanguageOverride();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.languageTag = languageTag;
        _x.translationBehavior = translationBehavior;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TranslationLanguageOverride[");
        b.append("languageTag=");
        b.append(this.languageTag);
        b.append(", ");
        b.append("translationBehavior=");
        b.append(this.translationBehavior);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
