package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "token"})
@JsonInclude(Include.NON_NULL)
public class TokenMeetingInfo extends MeetingInfo implements ODataType {

    @JsonProperty("token")
    protected String token;

    protected TokenMeetingInfo() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.tokenMeetingInfo";
    }

    @Property(name="token")
    @JsonIgnore
    public Optional<String> getToken() {
        return Optional.ofNullable(token);
    }

    public TokenMeetingInfo withToken(String token) {
        TokenMeetingInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.tokenMeetingInfo");
        _x.token = token;
        return _x;
    }

    public TokenMeetingInfo withUnmappedField(String name, Object value) {
        TokenMeetingInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTokenMeetingInfo() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean allowConversationWithoutHost;
        private String token;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder allowConversationWithoutHost(Boolean allowConversationWithoutHost) {
            this.allowConversationWithoutHost = allowConversationWithoutHost;
            this.changedFields = changedFields.add("allowConversationWithoutHost");
            return this;
        }

        public Builder token(String token) {
            this.token = token;
            this.changedFields = changedFields.add("token");
            return this;
        }

        public TokenMeetingInfo build() {
            TokenMeetingInfo _x = new TokenMeetingInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.tokenMeetingInfo";
            _x.allowConversationWithoutHost = allowConversationWithoutHost;
            _x.token = token;
            return _x;
        }
    }

    private TokenMeetingInfo _copy() {
        TokenMeetingInfo _x = new TokenMeetingInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.allowConversationWithoutHost = allowConversationWithoutHost;
        _x.token = token;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TokenMeetingInfo[");
        b.append("allowConversationWithoutHost=");
        b.append(this.allowConversationWithoutHost);
        b.append(", ");
        b.append("token=");
        b.append(this.token);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
