package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <i>“Parameter passed to GetHealthMetricTimeSeries when requesting snapshot time
 * series.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "endDateTime", 
    "metricName", 
    "startDateTime"})
@JsonInclude(Include.NON_NULL)
public class TimeSeriesParameter implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("endDateTime")
    protected OffsetDateTime endDateTime;

    @JsonProperty("metricName")
    protected String metricName;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    protected TimeSeriesParameter() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.timeSeriesParameter";
    }

    /**
     * <i>“End time of the series being requested. Optional; if not specified, current time
     * is used.”</i>
     * 
     * @return property endDateTime
     */
    @Property(name="endDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDateTime() {
        return Optional.ofNullable(endDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code endDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“End time of the series being requested. Optional; if not specified, current time
     * is used.”</i>
     * 
     * @param endDateTime
     *            new value of {@code endDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code endDateTime} field changed
     */
    public TimeSeriesParameter withEndDateTime(OffsetDateTime endDateTime) {
        TimeSeriesParameter _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeSeriesParameter");
        _x.endDateTime = endDateTime;
        return _x;
    }

    /**
     * <i>“The name of the metric for which a time series is requested.”</i>
     * 
     * @return property metricName
     */
    @Property(name="metricName")
    @JsonIgnore
    public Optional<String> getMetricName() {
        return Optional.ofNullable(metricName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code metricName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The name of the metric for which a time series is requested.”</i>
     * 
     * @param metricName
     *            new value of {@code metricName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code metricName} field changed
     */
    public TimeSeriesParameter withMetricName(String metricName) {
        TimeSeriesParameter _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeSeriesParameter");
        _x.metricName = metricName;
        return _x;
    }

    /**
     * <i>“Start time of the series being requested.”</i>
     * 
     * @return property startDateTime
     */
    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code startDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Start time of the series being requested.”</i>
     * 
     * @param startDateTime
     *            new value of {@code startDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startDateTime} field changed
     */
    public TimeSeriesParameter withStartDateTime(OffsetDateTime startDateTime) {
        TimeSeriesParameter _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeSeriesParameter");
        _x.startDateTime = startDateTime;
        return _x;
    }

    public TimeSeriesParameter withUnmappedField(String name, Object value) {
        TimeSeriesParameter _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime endDateTime;
        private String metricName;
        private OffsetDateTime startDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“End time of the series being requested. Optional; if not specified, current time
         * is used.”</i>
         * 
         * @param endDateTime
         *            value of {@code endDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        /**
         * <i>“The name of the metric for which a time series is requested.”</i>
         * 
         * @param metricName
         *            value of {@code metricName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder metricName(String metricName) {
            this.metricName = metricName;
            this.changedFields = changedFields.add("metricName");
            return this;
        }

        /**
         * <i>“Start time of the series being requested.”</i>
         * 
         * @param startDateTime
         *            value of {@code startDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public TimeSeriesParameter build() {
            TimeSeriesParameter _x = new TimeSeriesParameter();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.timeSeriesParameter";
            _x.endDateTime = endDateTime;
            _x.metricName = metricName;
            _x.startDateTime = startDateTime;
            return _x;
        }
    }

    private TimeSeriesParameter _copy() {
        TimeSeriesParameter _x = new TimeSeriesParameter();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.endDateTime = endDateTime;
        _x.metricName = metricName;
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TimeSeriesParameter[");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("metricName=");
        b.append(this.metricName);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
