package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.LocalTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "endTime", 
    "startTime"})
@JsonInclude(Include.NON_NULL)
public class TimeRange implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("endTime")
    protected LocalTime endTime;

    @JsonProperty("startTime")
    protected LocalTime startTime;

    protected TimeRange() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.timeRange";
    }

    @Property(name="endTime")
    @JsonIgnore
    public Optional<LocalTime> getEndTime() {
        return Optional.ofNullable(endTime);
    }

    public TimeRange withEndTime(LocalTime endTime) {
        TimeRange _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeRange");
        _x.endTime = endTime;
        return _x;
    }

    @Property(name="startTime")
    @JsonIgnore
    public Optional<LocalTime> getStartTime() {
        return Optional.ofNullable(startTime);
    }

    public TimeRange withStartTime(LocalTime startTime) {
        TimeRange _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeRange");
        _x.startTime = startTime;
        return _x;
    }

    public TimeRange withUnmappedField(String name, Object value) {
        TimeRange _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private LocalTime endTime;
        private LocalTime startTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder endTime(LocalTime endTime) {
            this.endTime = endTime;
            this.changedFields = changedFields.add("endTime");
            return this;
        }

        public Builder startTime(LocalTime startTime) {
            this.startTime = startTime;
            this.changedFields = changedFields.add("startTime");
            return this;
        }

        public TimeRange build() {
            TimeRange _x = new TimeRange();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.timeRange";
            _x.endTime = endTime;
            _x.startTime = startTime;
            return _x;
        }
    }

    private TimeRange _copy() {
        TimeRange _x = new TimeRange();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.endTime = endTime;
        _x.startTime = startTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TimeRange[");
        b.append("endTime=");
        b.append(this.endTime);
        b.append(", ");
        b.append("startTime=");
        b.append(this.startTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
