package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "atApprovedLocation", 
    "dateTime", 
    "notes"})
@JsonInclude(Include.NON_NULL)
public class TimeCardEvent implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("atApprovedLocation")
    protected Boolean atApprovedLocation;

    @JsonProperty("dateTime")
    protected OffsetDateTime dateTime;

    @JsonProperty("notes")
    protected ItemBody notes;

    protected TimeCardEvent() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.timeCardEvent";
    }

    @Property(name="atApprovedLocation")
    @JsonIgnore
    public Optional<Boolean> getAtApprovedLocation() {
        return Optional.ofNullable(atApprovedLocation);
    }

    public TimeCardEvent withAtApprovedLocation(Boolean atApprovedLocation) {
        TimeCardEvent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeCardEvent");
        _x.atApprovedLocation = atApprovedLocation;
        return _x;
    }

    @Property(name="dateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getDateTime() {
        return Optional.ofNullable(dateTime);
    }

    public TimeCardEvent withDateTime(OffsetDateTime dateTime) {
        TimeCardEvent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeCardEvent");
        _x.dateTime = dateTime;
        return _x;
    }

    @Property(name="notes")
    @JsonIgnore
    public Optional<ItemBody> getNotes() {
        return Optional.ofNullable(notes);
    }

    public TimeCardEvent withNotes(ItemBody notes) {
        TimeCardEvent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeCardEvent");
        _x.notes = notes;
        return _x;
    }

    public TimeCardEvent withUnmappedField(String name, Object value) {
        TimeCardEvent _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean atApprovedLocation;
        private OffsetDateTime dateTime;
        private ItemBody notes;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder atApprovedLocation(Boolean atApprovedLocation) {
            this.atApprovedLocation = atApprovedLocation;
            this.changedFields = changedFields.add("atApprovedLocation");
            return this;
        }

        public Builder dateTime(OffsetDateTime dateTime) {
            this.dateTime = dateTime;
            this.changedFields = changedFields.add("dateTime");
            return this;
        }

        public Builder notes(ItemBody notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("notes");
            return this;
        }

        public TimeCardEvent build() {
            TimeCardEvent _x = new TimeCardEvent();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.timeCardEvent";
            _x.atApprovedLocation = atApprovedLocation;
            _x.dateTime = dateTime;
            _x.notes = notes;
            return _x;
        }
    }

    private TimeCardEvent _copy() {
        TimeCardEvent _x = new TimeCardEvent();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.atApprovedLocation = atApprovedLocation;
        _x.dateTime = dateTime;
        _x.notes = notes;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TimeCardEvent[");
        b.append("atApprovedLocation=");
        b.append(this.atApprovedLocation);
        b.append(", ");
        b.append("dateTime=");
        b.append(this.dateTime);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
