package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "breaks", 
    "clockInEvent", 
    "clockOutEvent"})
@JsonInclude(Include.NON_NULL)
public class TimeCardEntry implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("breaks")
    protected List<TimeCardBreak> breaks;

    @JsonProperty("breaks@nextLink")
    protected String breaksNextLink;

    @JsonProperty("clockInEvent")
    protected TimeCardEvent clockInEvent;

    @JsonProperty("clockOutEvent")
    protected TimeCardEvent clockOutEvent;

    protected TimeCardEntry() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.timeCardEntry";
    }

    @Property(name="breaks")
    @JsonIgnore
    public CollectionPage<TimeCardBreak> getBreaks() {
        return new CollectionPage<TimeCardBreak>(contextPath, TimeCardBreak.class, this.breaks, Optional.ofNullable(breaksNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="breaks")
    @JsonIgnore
    public CollectionPage<TimeCardBreak> getBreaks(HttpRequestOptions options) {
        return new CollectionPage<TimeCardBreak>(contextPath, TimeCardBreak.class, this.breaks, Optional.ofNullable(breaksNextLink), Collections.emptyList(), options);
    }

    @Property(name="clockInEvent")
    @JsonIgnore
    public Optional<TimeCardEvent> getClockInEvent() {
        return Optional.ofNullable(clockInEvent);
    }

    public TimeCardEntry withClockInEvent(TimeCardEvent clockInEvent) {
        TimeCardEntry _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeCardEntry");
        _x.clockInEvent = clockInEvent;
        return _x;
    }

    @Property(name="clockOutEvent")
    @JsonIgnore
    public Optional<TimeCardEvent> getClockOutEvent() {
        return Optional.ofNullable(clockOutEvent);
    }

    public TimeCardEntry withClockOutEvent(TimeCardEvent clockOutEvent) {
        TimeCardEntry _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeCardEntry");
        _x.clockOutEvent = clockOutEvent;
        return _x;
    }

    public TimeCardEntry withUnmappedField(String name, Object value) {
        TimeCardEntry _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<TimeCardBreak> breaks;
        private String breaksNextLink;
        private TimeCardEvent clockInEvent;
        private TimeCardEvent clockOutEvent;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder breaks(List<TimeCardBreak> breaks) {
            this.breaks = breaks;
            this.changedFields = changedFields.add("breaks");
            return this;
        }

        public Builder breaks(TimeCardBreak... breaks) {
            return breaks(Arrays.asList(breaks));
        }

        public Builder breaksNextLink(String breaksNextLink) {
            this.breaksNextLink = breaksNextLink;
            this.changedFields = changedFields.add("breaks");
            return this;
        }

        public Builder clockInEvent(TimeCardEvent clockInEvent) {
            this.clockInEvent = clockInEvent;
            this.changedFields = changedFields.add("clockInEvent");
            return this;
        }

        public Builder clockOutEvent(TimeCardEvent clockOutEvent) {
            this.clockOutEvent = clockOutEvent;
            this.changedFields = changedFields.add("clockOutEvent");
            return this;
        }

        public TimeCardEntry build() {
            TimeCardEntry _x = new TimeCardEntry();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.timeCardEntry";
            _x.breaks = breaks;
            _x.breaksNextLink = breaksNextLink;
            _x.clockInEvent = clockInEvent;
            _x.clockOutEvent = clockOutEvent;
            return _x;
        }
    }

    private TimeCardEntry _copy() {
        TimeCardEntry _x = new TimeCardEntry();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.breaks = breaks;
        _x.clockInEvent = clockInEvent;
        _x.clockOutEvent = clockOutEvent;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TimeCardEntry[");
        b.append("breaks=");
        b.append(this.breaks);
        b.append(", ");
        b.append("clockInEvent=");
        b.append(this.clockInEvent);
        b.append(", ");
        b.append("clockOutEvent=");
        b.append(this.clockOutEvent);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
