package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "breakId", 
    "end", 
    "notes", 
    "start"})
@JsonInclude(Include.NON_NULL)
public class TimeCardBreak implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("breakId")
    protected String breakId;

    @JsonProperty("end")
    protected TimeCardEvent end;

    @JsonProperty("notes")
    protected ItemBody notes;

    @JsonProperty("start")
    protected TimeCardEvent start;

    protected TimeCardBreak() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.timeCardBreak";
    }

    @Property(name="breakId")
    @JsonIgnore
    public Optional<String> getBreakId() {
        return Optional.ofNullable(breakId);
    }

    public TimeCardBreak withBreakId(String breakId) {
        TimeCardBreak _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeCardBreak");
        _x.breakId = breakId;
        return _x;
    }

    @Property(name="end")
    @JsonIgnore
    public Optional<TimeCardEvent> getEnd() {
        return Optional.ofNullable(end);
    }

    public TimeCardBreak withEnd(TimeCardEvent end) {
        TimeCardBreak _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeCardBreak");
        _x.end = end;
        return _x;
    }

    @Property(name="notes")
    @JsonIgnore
    public Optional<ItemBody> getNotes() {
        return Optional.ofNullable(notes);
    }

    public TimeCardBreak withNotes(ItemBody notes) {
        TimeCardBreak _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeCardBreak");
        _x.notes = notes;
        return _x;
    }

    @Property(name="start")
    @JsonIgnore
    public Optional<TimeCardEvent> getStart() {
        return Optional.ofNullable(start);
    }

    public TimeCardBreak withStart(TimeCardEvent start) {
        TimeCardBreak _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeCardBreak");
        _x.start = start;
        return _x;
    }

    public TimeCardBreak withUnmappedField(String name, Object value) {
        TimeCardBreak _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String breakId;
        private TimeCardEvent end;
        private ItemBody notes;
        private TimeCardEvent start;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder breakId(String breakId) {
            this.breakId = breakId;
            this.changedFields = changedFields.add("breakId");
            return this;
        }

        public Builder end(TimeCardEvent end) {
            this.end = end;
            this.changedFields = changedFields.add("end");
            return this;
        }

        public Builder notes(ItemBody notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("notes");
            return this;
        }

        public Builder start(TimeCardEvent start) {
            this.start = start;
            this.changedFields = changedFields.add("start");
            return this;
        }

        public TimeCardBreak build() {
            TimeCardBreak _x = new TimeCardBreak();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.timeCardBreak";
            _x.breakId = breakId;
            _x.end = end;
            _x.notes = notes;
            _x.start = start;
            return _x;
        }
    }

    private TimeCardBreak _copy() {
        TimeCardBreak _x = new TimeCardBreak();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.breakId = breakId;
        _x.end = end;
        _x.notes = notes;
        _x.start = start;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TimeCardBreak[");
        b.append("breakId=");
        b.append(this.breakId);
        b.append(", ");
        b.append("end=");
        b.append(this.end);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append(", ");
        b.append("start=");
        b.append(this.start);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
