package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "allowMultipleValues", 
    "showFullyQualifiedName"})
@JsonInclude(Include.NON_NULL)
public class TermColumn implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("allowMultipleValues")
    protected Boolean allowMultipleValues;

    @JsonProperty("showFullyQualifiedName")
    protected Boolean showFullyQualifiedName;

    protected TermColumn() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.termColumn";
    }

    @Property(name="allowMultipleValues")
    @JsonIgnore
    public Optional<Boolean> getAllowMultipleValues() {
        return Optional.ofNullable(allowMultipleValues);
    }

    public TermColumn withAllowMultipleValues(Boolean allowMultipleValues) {
        TermColumn _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termColumn");
        _x.allowMultipleValues = allowMultipleValues;
        return _x;
    }

    @Property(name="showFullyQualifiedName")
    @JsonIgnore
    public Optional<Boolean> getShowFullyQualifiedName() {
        return Optional.ofNullable(showFullyQualifiedName);
    }

    public TermColumn withShowFullyQualifiedName(Boolean showFullyQualifiedName) {
        TermColumn _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termColumn");
        _x.showFullyQualifiedName = showFullyQualifiedName;
        return _x;
    }

    public TermColumn withUnmappedField(String name, Object value) {
        TermColumn _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean allowMultipleValues;
        private Boolean showFullyQualifiedName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder allowMultipleValues(Boolean allowMultipleValues) {
            this.allowMultipleValues = allowMultipleValues;
            this.changedFields = changedFields.add("allowMultipleValues");
            return this;
        }

        public Builder showFullyQualifiedName(Boolean showFullyQualifiedName) {
            this.showFullyQualifiedName = showFullyQualifiedName;
            this.changedFields = changedFields.add("showFullyQualifiedName");
            return this;
        }

        public TermColumn build() {
            TermColumn _x = new TermColumn();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.termColumn";
            _x.allowMultipleValues = allowMultipleValues;
            _x.showFullyQualifiedName = showFullyQualifiedName;
            return _x;
        }
    }

    private TermColumn _copy() {
        TermColumn _x = new TermColumn();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.allowMultipleValues = allowMultipleValues;
        _x.showFullyQualifiedName = showFullyQualifiedName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TermColumn[");
        b.append("allowMultipleValues=");
        b.append(this.allowMultipleValues);
        b.append(", ");
        b.append("showFullyQualifiedName=");
        b.append(this.showFullyQualifiedName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
