package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.TeamworkUserIdentityType;

@JsonPropertyOrder({
    "@odata.type", 
    "userIdentityType"})
@JsonInclude(Include.NON_NULL)
public class TeamworkUserIdentity extends Identity implements ODataType {

    @JsonProperty("userIdentityType")
    protected TeamworkUserIdentityType userIdentityType;

    protected TeamworkUserIdentity() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamworkUserIdentity";
    }

    @Property(name="userIdentityType")
    @JsonIgnore
    public Optional<TeamworkUserIdentityType> getUserIdentityType() {
        return Optional.ofNullable(userIdentityType);
    }

    public TeamworkUserIdentity withUserIdentityType(TeamworkUserIdentityType userIdentityType) {
        TeamworkUserIdentity _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkUserIdentity");
        _x.userIdentityType = userIdentityType;
        return _x;
    }

    public TeamworkUserIdentity withUnmappedField(String name, Object value) {
        TeamworkUserIdentity _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTeamworkUserIdentity() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private String id;
        private TeamworkUserIdentityType userIdentityType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder userIdentityType(TeamworkUserIdentityType userIdentityType) {
            this.userIdentityType = userIdentityType;
            this.changedFields = changedFields.add("userIdentityType");
            return this;
        }

        public TeamworkUserIdentity build() {
            TeamworkUserIdentity _x = new TeamworkUserIdentity();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamworkUserIdentity";
            _x.displayName = displayName;
            _x.id = id;
            _x.userIdentityType = userIdentityType;
            return _x;
        }
    }

    private TeamworkUserIdentity _copy() {
        TeamworkUserIdentity _x = new TeamworkUserIdentity();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.id = id;
        _x.userIdentityType = userIdentityType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamworkUserIdentity[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("userIdentityType=");
        b.append(this.userIdentityType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
