package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.TeamworkSoftwareFreshness;

@JsonPropertyOrder({
    "@odata.type", 
    "availableVersion", 
    "currentVersion", 
    "softwareFreshness"})
@JsonInclude(Include.NON_NULL)
public class TeamworkSoftwareUpdateStatus implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("availableVersion")
    protected String availableVersion;

    @JsonProperty("currentVersion")
    protected String currentVersion;

    @JsonProperty("softwareFreshness")
    protected TeamworkSoftwareFreshness softwareFreshness;

    protected TeamworkSoftwareUpdateStatus() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamworkSoftwareUpdateStatus";
    }

    @Property(name="availableVersion")
    @JsonIgnore
    public Optional<String> getAvailableVersion() {
        return Optional.ofNullable(availableVersion);
    }

    public TeamworkSoftwareUpdateStatus withAvailableVersion(String availableVersion) {
        TeamworkSoftwareUpdateStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkSoftwareUpdateStatus");
        _x.availableVersion = availableVersion;
        return _x;
    }

    @Property(name="currentVersion")
    @JsonIgnore
    public Optional<String> getCurrentVersion() {
        return Optional.ofNullable(currentVersion);
    }

    public TeamworkSoftwareUpdateStatus withCurrentVersion(String currentVersion) {
        TeamworkSoftwareUpdateStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkSoftwareUpdateStatus");
        _x.currentVersion = currentVersion;
        return _x;
    }

    @Property(name="softwareFreshness")
    @JsonIgnore
    public Optional<TeamworkSoftwareFreshness> getSoftwareFreshness() {
        return Optional.ofNullable(softwareFreshness);
    }

    public TeamworkSoftwareUpdateStatus withSoftwareFreshness(TeamworkSoftwareFreshness softwareFreshness) {
        TeamworkSoftwareUpdateStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkSoftwareUpdateStatus");
        _x.softwareFreshness = softwareFreshness;
        return _x;
    }

    public TeamworkSoftwareUpdateStatus withUnmappedField(String name, Object value) {
        TeamworkSoftwareUpdateStatus _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String availableVersion;
        private String currentVersion;
        private TeamworkSoftwareFreshness softwareFreshness;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder availableVersion(String availableVersion) {
            this.availableVersion = availableVersion;
            this.changedFields = changedFields.add("availableVersion");
            return this;
        }

        public Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            this.changedFields = changedFields.add("currentVersion");
            return this;
        }

        public Builder softwareFreshness(TeamworkSoftwareFreshness softwareFreshness) {
            this.softwareFreshness = softwareFreshness;
            this.changedFields = changedFields.add("softwareFreshness");
            return this;
        }

        public TeamworkSoftwareUpdateStatus build() {
            TeamworkSoftwareUpdateStatus _x = new TeamworkSoftwareUpdateStatus();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamworkSoftwareUpdateStatus";
            _x.availableVersion = availableVersion;
            _x.currentVersion = currentVersion;
            _x.softwareFreshness = softwareFreshness;
            return _x;
        }
    }

    private TeamworkSoftwareUpdateStatus _copy() {
        TeamworkSoftwareUpdateStatus _x = new TeamworkSoftwareUpdateStatus();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.availableVersion = availableVersion;
        _x.currentVersion = currentVersion;
        _x.softwareFreshness = softwareFreshness;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamworkSoftwareUpdateStatus[");
        b.append("availableVersion=");
        b.append(this.availableVersion);
        b.append(", ");
        b.append("currentVersion=");
        b.append(this.currentVersion);
        b.append(", ");
        b.append("softwareFreshness=");
        b.append(this.softwareFreshness);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
