package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "adminAgentSoftwareUpdateStatus", 
    "companyPortalSoftwareUpdateStatus", 
    "firmwareSoftwareUpdateStatus", 
    "operatingSystemSoftwareUpdateStatus", 
    "partnerAgentSoftwareUpdateStatus", 
    "teamsClientSoftwareUpdateStatus"})
@JsonInclude(Include.NON_NULL)
public class TeamworkSoftwareUpdateHealth implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("adminAgentSoftwareUpdateStatus")
    protected TeamworkSoftwareUpdateStatus adminAgentSoftwareUpdateStatus;

    @JsonProperty("companyPortalSoftwareUpdateStatus")
    protected TeamworkSoftwareUpdateStatus companyPortalSoftwareUpdateStatus;

    @JsonProperty("firmwareSoftwareUpdateStatus")
    protected TeamworkSoftwareUpdateStatus firmwareSoftwareUpdateStatus;

    @JsonProperty("operatingSystemSoftwareUpdateStatus")
    protected TeamworkSoftwareUpdateStatus operatingSystemSoftwareUpdateStatus;

    @JsonProperty("partnerAgentSoftwareUpdateStatus")
    protected TeamworkSoftwareUpdateStatus partnerAgentSoftwareUpdateStatus;

    @JsonProperty("teamsClientSoftwareUpdateStatus")
    protected TeamworkSoftwareUpdateStatus teamsClientSoftwareUpdateStatus;

    protected TeamworkSoftwareUpdateHealth() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamworkSoftwareUpdateHealth";
    }

    @Property(name="adminAgentSoftwareUpdateStatus")
    @JsonIgnore
    public Optional<TeamworkSoftwareUpdateStatus> getAdminAgentSoftwareUpdateStatus() {
        return Optional.ofNullable(adminAgentSoftwareUpdateStatus);
    }

    public TeamworkSoftwareUpdateHealth withAdminAgentSoftwareUpdateStatus(TeamworkSoftwareUpdateStatus adminAgentSoftwareUpdateStatus) {
        TeamworkSoftwareUpdateHealth _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkSoftwareUpdateHealth");
        _x.adminAgentSoftwareUpdateStatus = adminAgentSoftwareUpdateStatus;
        return _x;
    }

    @Property(name="companyPortalSoftwareUpdateStatus")
    @JsonIgnore
    public Optional<TeamworkSoftwareUpdateStatus> getCompanyPortalSoftwareUpdateStatus() {
        return Optional.ofNullable(companyPortalSoftwareUpdateStatus);
    }

    public TeamworkSoftwareUpdateHealth withCompanyPortalSoftwareUpdateStatus(TeamworkSoftwareUpdateStatus companyPortalSoftwareUpdateStatus) {
        TeamworkSoftwareUpdateHealth _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkSoftwareUpdateHealth");
        _x.companyPortalSoftwareUpdateStatus = companyPortalSoftwareUpdateStatus;
        return _x;
    }

    @Property(name="firmwareSoftwareUpdateStatus")
    @JsonIgnore
    public Optional<TeamworkSoftwareUpdateStatus> getFirmwareSoftwareUpdateStatus() {
        return Optional.ofNullable(firmwareSoftwareUpdateStatus);
    }

    public TeamworkSoftwareUpdateHealth withFirmwareSoftwareUpdateStatus(TeamworkSoftwareUpdateStatus firmwareSoftwareUpdateStatus) {
        TeamworkSoftwareUpdateHealth _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkSoftwareUpdateHealth");
        _x.firmwareSoftwareUpdateStatus = firmwareSoftwareUpdateStatus;
        return _x;
    }

    @Property(name="operatingSystemSoftwareUpdateStatus")
    @JsonIgnore
    public Optional<TeamworkSoftwareUpdateStatus> getOperatingSystemSoftwareUpdateStatus() {
        return Optional.ofNullable(operatingSystemSoftwareUpdateStatus);
    }

    public TeamworkSoftwareUpdateHealth withOperatingSystemSoftwareUpdateStatus(TeamworkSoftwareUpdateStatus operatingSystemSoftwareUpdateStatus) {
        TeamworkSoftwareUpdateHealth _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkSoftwareUpdateHealth");
        _x.operatingSystemSoftwareUpdateStatus = operatingSystemSoftwareUpdateStatus;
        return _x;
    }

    @Property(name="partnerAgentSoftwareUpdateStatus")
    @JsonIgnore
    public Optional<TeamworkSoftwareUpdateStatus> getPartnerAgentSoftwareUpdateStatus() {
        return Optional.ofNullable(partnerAgentSoftwareUpdateStatus);
    }

    public TeamworkSoftwareUpdateHealth withPartnerAgentSoftwareUpdateStatus(TeamworkSoftwareUpdateStatus partnerAgentSoftwareUpdateStatus) {
        TeamworkSoftwareUpdateHealth _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkSoftwareUpdateHealth");
        _x.partnerAgentSoftwareUpdateStatus = partnerAgentSoftwareUpdateStatus;
        return _x;
    }

    @Property(name="teamsClientSoftwareUpdateStatus")
    @JsonIgnore
    public Optional<TeamworkSoftwareUpdateStatus> getTeamsClientSoftwareUpdateStatus() {
        return Optional.ofNullable(teamsClientSoftwareUpdateStatus);
    }

    public TeamworkSoftwareUpdateHealth withTeamsClientSoftwareUpdateStatus(TeamworkSoftwareUpdateStatus teamsClientSoftwareUpdateStatus) {
        TeamworkSoftwareUpdateHealth _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkSoftwareUpdateHealth");
        _x.teamsClientSoftwareUpdateStatus = teamsClientSoftwareUpdateStatus;
        return _x;
    }

    public TeamworkSoftwareUpdateHealth withUnmappedField(String name, Object value) {
        TeamworkSoftwareUpdateHealth _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private TeamworkSoftwareUpdateStatus adminAgentSoftwareUpdateStatus;
        private TeamworkSoftwareUpdateStatus companyPortalSoftwareUpdateStatus;
        private TeamworkSoftwareUpdateStatus firmwareSoftwareUpdateStatus;
        private TeamworkSoftwareUpdateStatus operatingSystemSoftwareUpdateStatus;
        private TeamworkSoftwareUpdateStatus partnerAgentSoftwareUpdateStatus;
        private TeamworkSoftwareUpdateStatus teamsClientSoftwareUpdateStatus;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder adminAgentSoftwareUpdateStatus(TeamworkSoftwareUpdateStatus adminAgentSoftwareUpdateStatus) {
            this.adminAgentSoftwareUpdateStatus = adminAgentSoftwareUpdateStatus;
            this.changedFields = changedFields.add("adminAgentSoftwareUpdateStatus");
            return this;
        }

        public Builder companyPortalSoftwareUpdateStatus(TeamworkSoftwareUpdateStatus companyPortalSoftwareUpdateStatus) {
            this.companyPortalSoftwareUpdateStatus = companyPortalSoftwareUpdateStatus;
            this.changedFields = changedFields.add("companyPortalSoftwareUpdateStatus");
            return this;
        }

        public Builder firmwareSoftwareUpdateStatus(TeamworkSoftwareUpdateStatus firmwareSoftwareUpdateStatus) {
            this.firmwareSoftwareUpdateStatus = firmwareSoftwareUpdateStatus;
            this.changedFields = changedFields.add("firmwareSoftwareUpdateStatus");
            return this;
        }

        public Builder operatingSystemSoftwareUpdateStatus(TeamworkSoftwareUpdateStatus operatingSystemSoftwareUpdateStatus) {
            this.operatingSystemSoftwareUpdateStatus = operatingSystemSoftwareUpdateStatus;
            this.changedFields = changedFields.add("operatingSystemSoftwareUpdateStatus");
            return this;
        }

        public Builder partnerAgentSoftwareUpdateStatus(TeamworkSoftwareUpdateStatus partnerAgentSoftwareUpdateStatus) {
            this.partnerAgentSoftwareUpdateStatus = partnerAgentSoftwareUpdateStatus;
            this.changedFields = changedFields.add("partnerAgentSoftwareUpdateStatus");
            return this;
        }

        public Builder teamsClientSoftwareUpdateStatus(TeamworkSoftwareUpdateStatus teamsClientSoftwareUpdateStatus) {
            this.teamsClientSoftwareUpdateStatus = teamsClientSoftwareUpdateStatus;
            this.changedFields = changedFields.add("teamsClientSoftwareUpdateStatus");
            return this;
        }

        public TeamworkSoftwareUpdateHealth build() {
            TeamworkSoftwareUpdateHealth _x = new TeamworkSoftwareUpdateHealth();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamworkSoftwareUpdateHealth";
            _x.adminAgentSoftwareUpdateStatus = adminAgentSoftwareUpdateStatus;
            _x.companyPortalSoftwareUpdateStatus = companyPortalSoftwareUpdateStatus;
            _x.firmwareSoftwareUpdateStatus = firmwareSoftwareUpdateStatus;
            _x.operatingSystemSoftwareUpdateStatus = operatingSystemSoftwareUpdateStatus;
            _x.partnerAgentSoftwareUpdateStatus = partnerAgentSoftwareUpdateStatus;
            _x.teamsClientSoftwareUpdateStatus = teamsClientSoftwareUpdateStatus;
            return _x;
        }
    }

    private TeamworkSoftwareUpdateHealth _copy() {
        TeamworkSoftwareUpdateHealth _x = new TeamworkSoftwareUpdateHealth();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.adminAgentSoftwareUpdateStatus = adminAgentSoftwareUpdateStatus;
        _x.companyPortalSoftwareUpdateStatus = companyPortalSoftwareUpdateStatus;
        _x.firmwareSoftwareUpdateStatus = firmwareSoftwareUpdateStatus;
        _x.operatingSystemSoftwareUpdateStatus = operatingSystemSoftwareUpdateStatus;
        _x.partnerAgentSoftwareUpdateStatus = partnerAgentSoftwareUpdateStatus;
        _x.teamsClientSoftwareUpdateStatus = teamsClientSoftwareUpdateStatus;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamworkSoftwareUpdateHealth[");
        b.append("adminAgentSoftwareUpdateStatus=");
        b.append(this.adminAgentSoftwareUpdateStatus);
        b.append(", ");
        b.append("companyPortalSoftwareUpdateStatus=");
        b.append(this.companyPortalSoftwareUpdateStatus);
        b.append(", ");
        b.append("firmwareSoftwareUpdateStatus=");
        b.append(this.firmwareSoftwareUpdateStatus);
        b.append(", ");
        b.append("operatingSystemSoftwareUpdateStatus=");
        b.append(this.operatingSystemSoftwareUpdateStatus);
        b.append(", ");
        b.append("partnerAgentSoftwareUpdateStatus=");
        b.append(this.partnerAgentSoftwareUpdateStatus);
        b.append(", ");
        b.append("teamsClientSoftwareUpdateStatus=");
        b.append(this.teamsClientSoftwareUpdateStatus);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
