package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "communicationSpeakerHealth", 
    "contentCameraHealth", 
    "displayHealthCollection", 
    "microphoneHealth", 
    "roomCameraHealth", 
    "speakerHealth"})
@JsonInclude(Include.NON_NULL)
public class TeamworkPeripheralsHealth implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("communicationSpeakerHealth")
    protected TeamworkPeripheralHealth communicationSpeakerHealth;

    @JsonProperty("contentCameraHealth")
    protected TeamworkPeripheralHealth contentCameraHealth;

    @JsonProperty("displayHealthCollection")
    protected List<TeamworkPeripheralHealth> displayHealthCollection;

    @JsonProperty("displayHealthCollection@nextLink")
    protected String displayHealthCollectionNextLink;

    @JsonProperty("microphoneHealth")
    protected TeamworkPeripheralHealth microphoneHealth;

    @JsonProperty("roomCameraHealth")
    protected TeamworkPeripheralHealth roomCameraHealth;

    @JsonProperty("speakerHealth")
    protected TeamworkPeripheralHealth speakerHealth;

    protected TeamworkPeripheralsHealth() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamworkPeripheralsHealth";
    }

    @Property(name="communicationSpeakerHealth")
    @JsonIgnore
    public Optional<TeamworkPeripheralHealth> getCommunicationSpeakerHealth() {
        return Optional.ofNullable(communicationSpeakerHealth);
    }

    public TeamworkPeripheralsHealth withCommunicationSpeakerHealth(TeamworkPeripheralHealth communicationSpeakerHealth) {
        TeamworkPeripheralsHealth _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkPeripheralsHealth");
        _x.communicationSpeakerHealth = communicationSpeakerHealth;
        return _x;
    }

    @Property(name="contentCameraHealth")
    @JsonIgnore
    public Optional<TeamworkPeripheralHealth> getContentCameraHealth() {
        return Optional.ofNullable(contentCameraHealth);
    }

    public TeamworkPeripheralsHealth withContentCameraHealth(TeamworkPeripheralHealth contentCameraHealth) {
        TeamworkPeripheralsHealth _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkPeripheralsHealth");
        _x.contentCameraHealth = contentCameraHealth;
        return _x;
    }

    @Property(name="displayHealthCollection")
    @JsonIgnore
    public CollectionPage<TeamworkPeripheralHealth> getDisplayHealthCollection() {
        return new CollectionPage<TeamworkPeripheralHealth>(contextPath, TeamworkPeripheralHealth.class, this.displayHealthCollection, Optional.ofNullable(displayHealthCollectionNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="displayHealthCollection")
    @JsonIgnore
    public CollectionPage<TeamworkPeripheralHealth> getDisplayHealthCollection(HttpRequestOptions options) {
        return new CollectionPage<TeamworkPeripheralHealth>(contextPath, TeamworkPeripheralHealth.class, this.displayHealthCollection, Optional.ofNullable(displayHealthCollectionNextLink), Collections.emptyList(), options);
    }

    @Property(name="microphoneHealth")
    @JsonIgnore
    public Optional<TeamworkPeripheralHealth> getMicrophoneHealth() {
        return Optional.ofNullable(microphoneHealth);
    }

    public TeamworkPeripheralsHealth withMicrophoneHealth(TeamworkPeripheralHealth microphoneHealth) {
        TeamworkPeripheralsHealth _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkPeripheralsHealth");
        _x.microphoneHealth = microphoneHealth;
        return _x;
    }

    @Property(name="roomCameraHealth")
    @JsonIgnore
    public Optional<TeamworkPeripheralHealth> getRoomCameraHealth() {
        return Optional.ofNullable(roomCameraHealth);
    }

    public TeamworkPeripheralsHealth withRoomCameraHealth(TeamworkPeripheralHealth roomCameraHealth) {
        TeamworkPeripheralsHealth _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkPeripheralsHealth");
        _x.roomCameraHealth = roomCameraHealth;
        return _x;
    }

    @Property(name="speakerHealth")
    @JsonIgnore
    public Optional<TeamworkPeripheralHealth> getSpeakerHealth() {
        return Optional.ofNullable(speakerHealth);
    }

    public TeamworkPeripheralsHealth withSpeakerHealth(TeamworkPeripheralHealth speakerHealth) {
        TeamworkPeripheralsHealth _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkPeripheralsHealth");
        _x.speakerHealth = speakerHealth;
        return _x;
    }

    public TeamworkPeripheralsHealth withUnmappedField(String name, Object value) {
        TeamworkPeripheralsHealth _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private TeamworkPeripheralHealth communicationSpeakerHealth;
        private TeamworkPeripheralHealth contentCameraHealth;
        private List<TeamworkPeripheralHealth> displayHealthCollection;
        private String displayHealthCollectionNextLink;
        private TeamworkPeripheralHealth microphoneHealth;
        private TeamworkPeripheralHealth roomCameraHealth;
        private TeamworkPeripheralHealth speakerHealth;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder communicationSpeakerHealth(TeamworkPeripheralHealth communicationSpeakerHealth) {
            this.communicationSpeakerHealth = communicationSpeakerHealth;
            this.changedFields = changedFields.add("communicationSpeakerHealth");
            return this;
        }

        public Builder contentCameraHealth(TeamworkPeripheralHealth contentCameraHealth) {
            this.contentCameraHealth = contentCameraHealth;
            this.changedFields = changedFields.add("contentCameraHealth");
            return this;
        }

        public Builder displayHealthCollection(List<TeamworkPeripheralHealth> displayHealthCollection) {
            this.displayHealthCollection = displayHealthCollection;
            this.changedFields = changedFields.add("displayHealthCollection");
            return this;
        }

        public Builder displayHealthCollection(TeamworkPeripheralHealth... displayHealthCollection) {
            return displayHealthCollection(Arrays.asList(displayHealthCollection));
        }

        public Builder displayHealthCollectionNextLink(String displayHealthCollectionNextLink) {
            this.displayHealthCollectionNextLink = displayHealthCollectionNextLink;
            this.changedFields = changedFields.add("displayHealthCollection");
            return this;
        }

        public Builder microphoneHealth(TeamworkPeripheralHealth microphoneHealth) {
            this.microphoneHealth = microphoneHealth;
            this.changedFields = changedFields.add("microphoneHealth");
            return this;
        }

        public Builder roomCameraHealth(TeamworkPeripheralHealth roomCameraHealth) {
            this.roomCameraHealth = roomCameraHealth;
            this.changedFields = changedFields.add("roomCameraHealth");
            return this;
        }

        public Builder speakerHealth(TeamworkPeripheralHealth speakerHealth) {
            this.speakerHealth = speakerHealth;
            this.changedFields = changedFields.add("speakerHealth");
            return this;
        }

        public TeamworkPeripheralsHealth build() {
            TeamworkPeripheralsHealth _x = new TeamworkPeripheralsHealth();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamworkPeripheralsHealth";
            _x.communicationSpeakerHealth = communicationSpeakerHealth;
            _x.contentCameraHealth = contentCameraHealth;
            _x.displayHealthCollection = displayHealthCollection;
            _x.displayHealthCollectionNextLink = displayHealthCollectionNextLink;
            _x.microphoneHealth = microphoneHealth;
            _x.roomCameraHealth = roomCameraHealth;
            _x.speakerHealth = speakerHealth;
            return _x;
        }
    }

    private TeamworkPeripheralsHealth _copy() {
        TeamworkPeripheralsHealth _x = new TeamworkPeripheralsHealth();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.communicationSpeakerHealth = communicationSpeakerHealth;
        _x.contentCameraHealth = contentCameraHealth;
        _x.displayHealthCollection = displayHealthCollection;
        _x.microphoneHealth = microphoneHealth;
        _x.roomCameraHealth = roomCameraHealth;
        _x.speakerHealth = speakerHealth;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamworkPeripheralsHealth[");
        b.append("communicationSpeakerHealth=");
        b.append(this.communicationSpeakerHealth);
        b.append(", ");
        b.append("contentCameraHealth=");
        b.append(this.contentCameraHealth);
        b.append(", ");
        b.append("displayHealthCollection=");
        b.append(this.displayHealthCollection);
        b.append(", ");
        b.append("microphoneHealth=");
        b.append(this.microphoneHealth);
        b.append(", ");
        b.append("roomCameraHealth=");
        b.append(this.roomCameraHealth);
        b.append(", ");
        b.append("speakerHealth=");
        b.append(this.speakerHealth);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
