package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "domain", 
    "domainUserName", 
    "smtpAddress"})
@JsonInclude(Include.NON_NULL)
public class TeamworkOnPremisesCalendarSyncConfiguration implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("domain")
    protected String domain;

    @JsonProperty("domainUserName")
    protected String domainUserName;

    @JsonProperty("smtpAddress")
    protected String smtpAddress;

    protected TeamworkOnPremisesCalendarSyncConfiguration() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamworkOnPremisesCalendarSyncConfiguration";
    }

    @Property(name="domain")
    @JsonIgnore
    public Optional<String> getDomain() {
        return Optional.ofNullable(domain);
    }

    public TeamworkOnPremisesCalendarSyncConfiguration withDomain(String domain) {
        TeamworkOnPremisesCalendarSyncConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkOnPremisesCalendarSyncConfiguration");
        _x.domain = domain;
        return _x;
    }

    @Property(name="domainUserName")
    @JsonIgnore
    public Optional<String> getDomainUserName() {
        return Optional.ofNullable(domainUserName);
    }

    public TeamworkOnPremisesCalendarSyncConfiguration withDomainUserName(String domainUserName) {
        TeamworkOnPremisesCalendarSyncConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkOnPremisesCalendarSyncConfiguration");
        _x.domainUserName = domainUserName;
        return _x;
    }

    @Property(name="smtpAddress")
    @JsonIgnore
    public Optional<String> getSmtpAddress() {
        return Optional.ofNullable(smtpAddress);
    }

    public TeamworkOnPremisesCalendarSyncConfiguration withSmtpAddress(String smtpAddress) {
        TeamworkOnPremisesCalendarSyncConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkOnPremisesCalendarSyncConfiguration");
        _x.smtpAddress = smtpAddress;
        return _x;
    }

    public TeamworkOnPremisesCalendarSyncConfiguration withUnmappedField(String name, Object value) {
        TeamworkOnPremisesCalendarSyncConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String domain;
        private String domainUserName;
        private String smtpAddress;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder domain(String domain) {
            this.domain = domain;
            this.changedFields = changedFields.add("domain");
            return this;
        }

        public Builder domainUserName(String domainUserName) {
            this.domainUserName = domainUserName;
            this.changedFields = changedFields.add("domainUserName");
            return this;
        }

        public Builder smtpAddress(String smtpAddress) {
            this.smtpAddress = smtpAddress;
            this.changedFields = changedFields.add("smtpAddress");
            return this;
        }

        public TeamworkOnPremisesCalendarSyncConfiguration build() {
            TeamworkOnPremisesCalendarSyncConfiguration _x = new TeamworkOnPremisesCalendarSyncConfiguration();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamworkOnPremisesCalendarSyncConfiguration";
            _x.domain = domain;
            _x.domainUserName = domainUserName;
            _x.smtpAddress = smtpAddress;
            return _x;
        }
    }

    private TeamworkOnPremisesCalendarSyncConfiguration _copy() {
        TeamworkOnPremisesCalendarSyncConfiguration _x = new TeamworkOnPremisesCalendarSyncConfiguration();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.domain = domain;
        _x.domainUserName = domainUserName;
        _x.smtpAddress = smtpAddress;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamworkOnPremisesCalendarSyncConfiguration[");
        b.append("domain=");
        b.append(this.domain);
        b.append(", ");
        b.append("domainUserName=");
        b.append(this.domainUserName);
        b.append(", ");
        b.append("smtpAddress=");
        b.append(this.smtpAddress);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
