package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "exchangeConnection", 
    "skypeConnection", 
    "teamsConnection"})
@JsonInclude(Include.NON_NULL)
public class TeamworkLoginStatus implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("exchangeConnection")
    protected TeamworkConnection exchangeConnection;

    @JsonProperty("skypeConnection")
    protected TeamworkConnection skypeConnection;

    @JsonProperty("teamsConnection")
    protected TeamworkConnection teamsConnection;

    protected TeamworkLoginStatus() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamworkLoginStatus";
    }

    @Property(name="exchangeConnection")
    @JsonIgnore
    public Optional<TeamworkConnection> getExchangeConnection() {
        return Optional.ofNullable(exchangeConnection);
    }

    public TeamworkLoginStatus withExchangeConnection(TeamworkConnection exchangeConnection) {
        TeamworkLoginStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkLoginStatus");
        _x.exchangeConnection = exchangeConnection;
        return _x;
    }

    @Property(name="skypeConnection")
    @JsonIgnore
    public Optional<TeamworkConnection> getSkypeConnection() {
        return Optional.ofNullable(skypeConnection);
    }

    public TeamworkLoginStatus withSkypeConnection(TeamworkConnection skypeConnection) {
        TeamworkLoginStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkLoginStatus");
        _x.skypeConnection = skypeConnection;
        return _x;
    }

    @Property(name="teamsConnection")
    @JsonIgnore
    public Optional<TeamworkConnection> getTeamsConnection() {
        return Optional.ofNullable(teamsConnection);
    }

    public TeamworkLoginStatus withTeamsConnection(TeamworkConnection teamsConnection) {
        TeamworkLoginStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkLoginStatus");
        _x.teamsConnection = teamsConnection;
        return _x;
    }

    public TeamworkLoginStatus withUnmappedField(String name, Object value) {
        TeamworkLoginStatus _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private TeamworkConnection exchangeConnection;
        private TeamworkConnection skypeConnection;
        private TeamworkConnection teamsConnection;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder exchangeConnection(TeamworkConnection exchangeConnection) {
            this.exchangeConnection = exchangeConnection;
            this.changedFields = changedFields.add("exchangeConnection");
            return this;
        }

        public Builder skypeConnection(TeamworkConnection skypeConnection) {
            this.skypeConnection = skypeConnection;
            this.changedFields = changedFields.add("skypeConnection");
            return this;
        }

        public Builder teamsConnection(TeamworkConnection teamsConnection) {
            this.teamsConnection = teamsConnection;
            this.changedFields = changedFields.add("teamsConnection");
            return this;
        }

        public TeamworkLoginStatus build() {
            TeamworkLoginStatus _x = new TeamworkLoginStatus();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamworkLoginStatus";
            _x.exchangeConnection = exchangeConnection;
            _x.skypeConnection = skypeConnection;
            _x.teamsConnection = teamsConnection;
            return _x;
        }
    }

    private TeamworkLoginStatus _copy() {
        TeamworkLoginStatus _x = new TeamworkLoginStatus();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.exchangeConnection = exchangeConnection;
        _x.skypeConnection = skypeConnection;
        _x.teamsConnection = teamsConnection;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamworkLoginStatus[");
        b.append("exchangeConnection=");
        b.append(this.exchangeConnection);
        b.append(", ");
        b.append("skypeConnection=");
        b.append(this.skypeConnection);
        b.append(", ");
        b.append("teamsConnection=");
        b.append(this.teamsConnection);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
