package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "macAddresses", 
    "manufacturer", 
    "model", 
    "serialNumber", 
    "uniqueId"})
@JsonInclude(Include.NON_NULL)
public class TeamworkHardwareDetail implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("macAddresses")
    protected List<String> macAddresses;

    @JsonProperty("macAddresses@nextLink")
    protected String macAddressesNextLink;

    @JsonProperty("manufacturer")
    protected String manufacturer;

    @JsonProperty("model")
    protected String model;

    @JsonProperty("serialNumber")
    protected String serialNumber;

    @JsonProperty("uniqueId")
    protected String uniqueId;

    protected TeamworkHardwareDetail() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamworkHardwareDetail";
    }

    @Property(name="macAddresses")
    @JsonIgnore
    public CollectionPage<String> getMacAddresses() {
        return new CollectionPage<String>(contextPath, String.class, this.macAddresses, Optional.ofNullable(macAddressesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="macAddresses")
    @JsonIgnore
    public CollectionPage<String> getMacAddresses(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.macAddresses, Optional.ofNullable(macAddressesNextLink), Collections.emptyList(), options);
    }

    @Property(name="manufacturer")
    @JsonIgnore
    public Optional<String> getManufacturer() {
        return Optional.ofNullable(manufacturer);
    }

    public TeamworkHardwareDetail withManufacturer(String manufacturer) {
        TeamworkHardwareDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkHardwareDetail");
        _x.manufacturer = manufacturer;
        return _x;
    }

    @Property(name="model")
    @JsonIgnore
    public Optional<String> getModel() {
        return Optional.ofNullable(model);
    }

    public TeamworkHardwareDetail withModel(String model) {
        TeamworkHardwareDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkHardwareDetail");
        _x.model = model;
        return _x;
    }

    @Property(name="serialNumber")
    @JsonIgnore
    public Optional<String> getSerialNumber() {
        return Optional.ofNullable(serialNumber);
    }

    public TeamworkHardwareDetail withSerialNumber(String serialNumber) {
        TeamworkHardwareDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkHardwareDetail");
        _x.serialNumber = serialNumber;
        return _x;
    }

    @Property(name="uniqueId")
    @JsonIgnore
    public Optional<String> getUniqueId() {
        return Optional.ofNullable(uniqueId);
    }

    public TeamworkHardwareDetail withUniqueId(String uniqueId) {
        TeamworkHardwareDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkHardwareDetail");
        _x.uniqueId = uniqueId;
        return _x;
    }

    public TeamworkHardwareDetail withUnmappedField(String name, Object value) {
        TeamworkHardwareDetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> macAddresses;
        private String macAddressesNextLink;
        private String manufacturer;
        private String model;
        private String serialNumber;
        private String uniqueId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder macAddresses(List<String> macAddresses) {
            this.macAddresses = macAddresses;
            this.changedFields = changedFields.add("macAddresses");
            return this;
        }

        public Builder macAddresses(String... macAddresses) {
            return macAddresses(Arrays.asList(macAddresses));
        }

        public Builder macAddressesNextLink(String macAddressesNextLink) {
            this.macAddressesNextLink = macAddressesNextLink;
            this.changedFields = changedFields.add("macAddresses");
            return this;
        }

        public Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            this.changedFields = changedFields.add("manufacturer");
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            this.changedFields = changedFields.add("model");
            return this;
        }

        public Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            this.changedFields = changedFields.add("serialNumber");
            return this;
        }

        public Builder uniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            this.changedFields = changedFields.add("uniqueId");
            return this;
        }

        public TeamworkHardwareDetail build() {
            TeamworkHardwareDetail _x = new TeamworkHardwareDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamworkHardwareDetail";
            _x.macAddresses = macAddresses;
            _x.macAddressesNextLink = macAddressesNextLink;
            _x.manufacturer = manufacturer;
            _x.model = model;
            _x.serialNumber = serialNumber;
            _x.uniqueId = uniqueId;
            return _x;
        }
    }

    private TeamworkHardwareDetail _copy() {
        TeamworkHardwareDetail _x = new TeamworkHardwareDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.macAddresses = macAddresses;
        _x.manufacturer = manufacturer;
        _x.model = model;
        _x.serialNumber = serialNumber;
        _x.uniqueId = uniqueId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamworkHardwareDetail[");
        b.append("macAddresses=");
        b.append(this.macAddresses);
        b.append(", ");
        b.append("manufacturer=");
        b.append(this.manufacturer);
        b.append(", ");
        b.append("model=");
        b.append(this.model);
        b.append(", ");
        b.append("serialNumber=");
        b.append(this.serialNumber);
        b.append(", ");
        b.append("uniqueId=");
        b.append(this.uniqueId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
