package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "emailToSendLogsAndFeedback", 
    "isAutoScreenShareEnabled", 
    "isBluetoothBeaconingEnabled", 
    "isHideMeetingNamesEnabled", 
    "isSendLogsAndFeedbackEnabled"})
@JsonInclude(Include.NON_NULL)
public class TeamworkFeaturesConfiguration implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("emailToSendLogsAndFeedback")
    protected String emailToSendLogsAndFeedback;

    @JsonProperty("isAutoScreenShareEnabled")
    protected Boolean isAutoScreenShareEnabled;

    @JsonProperty("isBluetoothBeaconingEnabled")
    protected Boolean isBluetoothBeaconingEnabled;

    @JsonProperty("isHideMeetingNamesEnabled")
    protected Boolean isHideMeetingNamesEnabled;

    @JsonProperty("isSendLogsAndFeedbackEnabled")
    protected Boolean isSendLogsAndFeedbackEnabled;

    protected TeamworkFeaturesConfiguration() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamworkFeaturesConfiguration";
    }

    @Property(name="emailToSendLogsAndFeedback")
    @JsonIgnore
    public Optional<String> getEmailToSendLogsAndFeedback() {
        return Optional.ofNullable(emailToSendLogsAndFeedback);
    }

    public TeamworkFeaturesConfiguration withEmailToSendLogsAndFeedback(String emailToSendLogsAndFeedback) {
        TeamworkFeaturesConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkFeaturesConfiguration");
        _x.emailToSendLogsAndFeedback = emailToSendLogsAndFeedback;
        return _x;
    }

    @Property(name="isAutoScreenShareEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsAutoScreenShareEnabled() {
        return Optional.ofNullable(isAutoScreenShareEnabled);
    }

    public TeamworkFeaturesConfiguration withIsAutoScreenShareEnabled(Boolean isAutoScreenShareEnabled) {
        TeamworkFeaturesConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkFeaturesConfiguration");
        _x.isAutoScreenShareEnabled = isAutoScreenShareEnabled;
        return _x;
    }

    @Property(name="isBluetoothBeaconingEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsBluetoothBeaconingEnabled() {
        return Optional.ofNullable(isBluetoothBeaconingEnabled);
    }

    public TeamworkFeaturesConfiguration withIsBluetoothBeaconingEnabled(Boolean isBluetoothBeaconingEnabled) {
        TeamworkFeaturesConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkFeaturesConfiguration");
        _x.isBluetoothBeaconingEnabled = isBluetoothBeaconingEnabled;
        return _x;
    }

    @Property(name="isHideMeetingNamesEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsHideMeetingNamesEnabled() {
        return Optional.ofNullable(isHideMeetingNamesEnabled);
    }

    public TeamworkFeaturesConfiguration withIsHideMeetingNamesEnabled(Boolean isHideMeetingNamesEnabled) {
        TeamworkFeaturesConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkFeaturesConfiguration");
        _x.isHideMeetingNamesEnabled = isHideMeetingNamesEnabled;
        return _x;
    }

    @Property(name="isSendLogsAndFeedbackEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsSendLogsAndFeedbackEnabled() {
        return Optional.ofNullable(isSendLogsAndFeedbackEnabled);
    }

    public TeamworkFeaturesConfiguration withIsSendLogsAndFeedbackEnabled(Boolean isSendLogsAndFeedbackEnabled) {
        TeamworkFeaturesConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkFeaturesConfiguration");
        _x.isSendLogsAndFeedbackEnabled = isSendLogsAndFeedbackEnabled;
        return _x;
    }

    public TeamworkFeaturesConfiguration withUnmappedField(String name, Object value) {
        TeamworkFeaturesConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String emailToSendLogsAndFeedback;
        private Boolean isAutoScreenShareEnabled;
        private Boolean isBluetoothBeaconingEnabled;
        private Boolean isHideMeetingNamesEnabled;
        private Boolean isSendLogsAndFeedbackEnabled;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder emailToSendLogsAndFeedback(String emailToSendLogsAndFeedback) {
            this.emailToSendLogsAndFeedback = emailToSendLogsAndFeedback;
            this.changedFields = changedFields.add("emailToSendLogsAndFeedback");
            return this;
        }

        public Builder isAutoScreenShareEnabled(Boolean isAutoScreenShareEnabled) {
            this.isAutoScreenShareEnabled = isAutoScreenShareEnabled;
            this.changedFields = changedFields.add("isAutoScreenShareEnabled");
            return this;
        }

        public Builder isBluetoothBeaconingEnabled(Boolean isBluetoothBeaconingEnabled) {
            this.isBluetoothBeaconingEnabled = isBluetoothBeaconingEnabled;
            this.changedFields = changedFields.add("isBluetoothBeaconingEnabled");
            return this;
        }

        public Builder isHideMeetingNamesEnabled(Boolean isHideMeetingNamesEnabled) {
            this.isHideMeetingNamesEnabled = isHideMeetingNamesEnabled;
            this.changedFields = changedFields.add("isHideMeetingNamesEnabled");
            return this;
        }

        public Builder isSendLogsAndFeedbackEnabled(Boolean isSendLogsAndFeedbackEnabled) {
            this.isSendLogsAndFeedbackEnabled = isSendLogsAndFeedbackEnabled;
            this.changedFields = changedFields.add("isSendLogsAndFeedbackEnabled");
            return this;
        }

        public TeamworkFeaturesConfiguration build() {
            TeamworkFeaturesConfiguration _x = new TeamworkFeaturesConfiguration();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamworkFeaturesConfiguration";
            _x.emailToSendLogsAndFeedback = emailToSendLogsAndFeedback;
            _x.isAutoScreenShareEnabled = isAutoScreenShareEnabled;
            _x.isBluetoothBeaconingEnabled = isBluetoothBeaconingEnabled;
            _x.isHideMeetingNamesEnabled = isHideMeetingNamesEnabled;
            _x.isSendLogsAndFeedbackEnabled = isSendLogsAndFeedbackEnabled;
            return _x;
        }
    }

    private TeamworkFeaturesConfiguration _copy() {
        TeamworkFeaturesConfiguration _x = new TeamworkFeaturesConfiguration();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.emailToSendLogsAndFeedback = emailToSendLogsAndFeedback;
        _x.isAutoScreenShareEnabled = isAutoScreenShareEnabled;
        _x.isBluetoothBeaconingEnabled = isBluetoothBeaconingEnabled;
        _x.isHideMeetingNamesEnabled = isHideMeetingNamesEnabled;
        _x.isSendLogsAndFeedbackEnabled = isSendLogsAndFeedbackEnabled;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamworkFeaturesConfiguration[");
        b.append("emailToSendLogsAndFeedback=");
        b.append(this.emailToSendLogsAndFeedback);
        b.append(", ");
        b.append("isAutoScreenShareEnabled=");
        b.append(this.isAutoScreenShareEnabled);
        b.append(", ");
        b.append("isBluetoothBeaconingEnabled=");
        b.append(this.isBluetoothBeaconingEnabled);
        b.append(", ");
        b.append("isHideMeetingNamesEnabled=");
        b.append(this.isHideMeetingNamesEnabled);
        b.append(", ");
        b.append("isSendLogsAndFeedbackEnabled=");
        b.append(this.isSendLogsAndFeedbackEnabled);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
