package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.Duration;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "backlightBrightness", 
    "backlightTimeout", 
    "isHighContrastEnabled", 
    "isScreensaverEnabled", 
    "screensaverTimeout"})
@JsonInclude(Include.NON_NULL)
public class TeamworkDisplayScreenConfiguration implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("backlightBrightness")
    protected Integer backlightBrightness;

    @JsonProperty("backlightTimeout")
    protected Duration backlightTimeout;

    @JsonProperty("isHighContrastEnabled")
    protected Boolean isHighContrastEnabled;

    @JsonProperty("isScreensaverEnabled")
    protected Boolean isScreensaverEnabled;

    @JsonProperty("screensaverTimeout")
    protected Duration screensaverTimeout;

    protected TeamworkDisplayScreenConfiguration() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamworkDisplayScreenConfiguration";
    }

    @Property(name="backlightBrightness")
    @JsonIgnore
    public Optional<Integer> getBacklightBrightness() {
        return Optional.ofNullable(backlightBrightness);
    }

    public TeamworkDisplayScreenConfiguration withBacklightBrightness(Integer backlightBrightness) {
        TeamworkDisplayScreenConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDisplayScreenConfiguration");
        _x.backlightBrightness = backlightBrightness;
        return _x;
    }

    @Property(name="backlightTimeout")
    @JsonIgnore
    public Optional<Duration> getBacklightTimeout() {
        return Optional.ofNullable(backlightTimeout);
    }

    public TeamworkDisplayScreenConfiguration withBacklightTimeout(Duration backlightTimeout) {
        TeamworkDisplayScreenConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDisplayScreenConfiguration");
        _x.backlightTimeout = backlightTimeout;
        return _x;
    }

    @Property(name="isHighContrastEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsHighContrastEnabled() {
        return Optional.ofNullable(isHighContrastEnabled);
    }

    public TeamworkDisplayScreenConfiguration withIsHighContrastEnabled(Boolean isHighContrastEnabled) {
        TeamworkDisplayScreenConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDisplayScreenConfiguration");
        _x.isHighContrastEnabled = isHighContrastEnabled;
        return _x;
    }

    @Property(name="isScreensaverEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsScreensaverEnabled() {
        return Optional.ofNullable(isScreensaverEnabled);
    }

    public TeamworkDisplayScreenConfiguration withIsScreensaverEnabled(Boolean isScreensaverEnabled) {
        TeamworkDisplayScreenConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDisplayScreenConfiguration");
        _x.isScreensaverEnabled = isScreensaverEnabled;
        return _x;
    }

    @Property(name="screensaverTimeout")
    @JsonIgnore
    public Optional<Duration> getScreensaverTimeout() {
        return Optional.ofNullable(screensaverTimeout);
    }

    public TeamworkDisplayScreenConfiguration withScreensaverTimeout(Duration screensaverTimeout) {
        TeamworkDisplayScreenConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDisplayScreenConfiguration");
        _x.screensaverTimeout = screensaverTimeout;
        return _x;
    }

    public TeamworkDisplayScreenConfiguration withUnmappedField(String name, Object value) {
        TeamworkDisplayScreenConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer backlightBrightness;
        private Duration backlightTimeout;
        private Boolean isHighContrastEnabled;
        private Boolean isScreensaverEnabled;
        private Duration screensaverTimeout;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder backlightBrightness(Integer backlightBrightness) {
            this.backlightBrightness = backlightBrightness;
            this.changedFields = changedFields.add("backlightBrightness");
            return this;
        }

        public Builder backlightTimeout(Duration backlightTimeout) {
            this.backlightTimeout = backlightTimeout;
            this.changedFields = changedFields.add("backlightTimeout");
            return this;
        }

        public Builder isHighContrastEnabled(Boolean isHighContrastEnabled) {
            this.isHighContrastEnabled = isHighContrastEnabled;
            this.changedFields = changedFields.add("isHighContrastEnabled");
            return this;
        }

        public Builder isScreensaverEnabled(Boolean isScreensaverEnabled) {
            this.isScreensaverEnabled = isScreensaverEnabled;
            this.changedFields = changedFields.add("isScreensaverEnabled");
            return this;
        }

        public Builder screensaverTimeout(Duration screensaverTimeout) {
            this.screensaverTimeout = screensaverTimeout;
            this.changedFields = changedFields.add("screensaverTimeout");
            return this;
        }

        public TeamworkDisplayScreenConfiguration build() {
            TeamworkDisplayScreenConfiguration _x = new TeamworkDisplayScreenConfiguration();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamworkDisplayScreenConfiguration";
            _x.backlightBrightness = backlightBrightness;
            _x.backlightTimeout = backlightTimeout;
            _x.isHighContrastEnabled = isHighContrastEnabled;
            _x.isScreensaverEnabled = isScreensaverEnabled;
            _x.screensaverTimeout = screensaverTimeout;
            return _x;
        }
    }

    private TeamworkDisplayScreenConfiguration _copy() {
        TeamworkDisplayScreenConfiguration _x = new TeamworkDisplayScreenConfiguration();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.backlightBrightness = backlightBrightness;
        _x.backlightTimeout = backlightTimeout;
        _x.isHighContrastEnabled = isHighContrastEnabled;
        _x.isScreensaverEnabled = isScreensaverEnabled;
        _x.screensaverTimeout = screensaverTimeout;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamworkDisplayScreenConfiguration[");
        b.append("backlightBrightness=");
        b.append(this.backlightBrightness);
        b.append(", ");
        b.append("backlightTimeout=");
        b.append(this.backlightTimeout);
        b.append(", ");
        b.append("isHighContrastEnabled=");
        b.append(this.isHighContrastEnabled);
        b.append(", ");
        b.append("isScreensaverEnabled=");
        b.append(this.isScreensaverEnabled);
        b.append(", ");
        b.append("screensaverTimeout=");
        b.append(this.screensaverTimeout);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
