package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "configuredDisplays", 
    "displayCount", 
    "inBuiltDisplayScreenConfiguration", 
    "isContentDuplicationAllowed", 
    "isDualDisplayModeEnabled"})
@JsonInclude(Include.NON_NULL)
public class TeamworkDisplayConfiguration implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("configuredDisplays")
    protected List<TeamworkConfiguredPeripheral> configuredDisplays;

    @JsonProperty("configuredDisplays@nextLink")
    protected String configuredDisplaysNextLink;

    @JsonProperty("displayCount")
    protected Integer displayCount;

    @JsonProperty("inBuiltDisplayScreenConfiguration")
    protected TeamworkDisplayScreenConfiguration inBuiltDisplayScreenConfiguration;

    @JsonProperty("isContentDuplicationAllowed")
    protected Boolean isContentDuplicationAllowed;

    @JsonProperty("isDualDisplayModeEnabled")
    protected Boolean isDualDisplayModeEnabled;

    protected TeamworkDisplayConfiguration() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamworkDisplayConfiguration";
    }

    @Property(name="configuredDisplays")
    @JsonIgnore
    public CollectionPage<TeamworkConfiguredPeripheral> getConfiguredDisplays() {
        return new CollectionPage<TeamworkConfiguredPeripheral>(contextPath, TeamworkConfiguredPeripheral.class, this.configuredDisplays, Optional.ofNullable(configuredDisplaysNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="configuredDisplays")
    @JsonIgnore
    public CollectionPage<TeamworkConfiguredPeripheral> getConfiguredDisplays(HttpRequestOptions options) {
        return new CollectionPage<TeamworkConfiguredPeripheral>(contextPath, TeamworkConfiguredPeripheral.class, this.configuredDisplays, Optional.ofNullable(configuredDisplaysNextLink), Collections.emptyList(), options);
    }

    @Property(name="displayCount")
    @JsonIgnore
    public Optional<Integer> getDisplayCount() {
        return Optional.ofNullable(displayCount);
    }

    public TeamworkDisplayConfiguration withDisplayCount(Integer displayCount) {
        TeamworkDisplayConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDisplayConfiguration");
        _x.displayCount = displayCount;
        return _x;
    }

    @Property(name="inBuiltDisplayScreenConfiguration")
    @JsonIgnore
    public Optional<TeamworkDisplayScreenConfiguration> getInBuiltDisplayScreenConfiguration() {
        return Optional.ofNullable(inBuiltDisplayScreenConfiguration);
    }

    public TeamworkDisplayConfiguration withInBuiltDisplayScreenConfiguration(TeamworkDisplayScreenConfiguration inBuiltDisplayScreenConfiguration) {
        TeamworkDisplayConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDisplayConfiguration");
        _x.inBuiltDisplayScreenConfiguration = inBuiltDisplayScreenConfiguration;
        return _x;
    }

    @Property(name="isContentDuplicationAllowed")
    @JsonIgnore
    public Optional<Boolean> getIsContentDuplicationAllowed() {
        return Optional.ofNullable(isContentDuplicationAllowed);
    }

    public TeamworkDisplayConfiguration withIsContentDuplicationAllowed(Boolean isContentDuplicationAllowed) {
        TeamworkDisplayConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDisplayConfiguration");
        _x.isContentDuplicationAllowed = isContentDuplicationAllowed;
        return _x;
    }

    @Property(name="isDualDisplayModeEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsDualDisplayModeEnabled() {
        return Optional.ofNullable(isDualDisplayModeEnabled);
    }

    public TeamworkDisplayConfiguration withIsDualDisplayModeEnabled(Boolean isDualDisplayModeEnabled) {
        TeamworkDisplayConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDisplayConfiguration");
        _x.isDualDisplayModeEnabled = isDualDisplayModeEnabled;
        return _x;
    }

    public TeamworkDisplayConfiguration withUnmappedField(String name, Object value) {
        TeamworkDisplayConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<TeamworkConfiguredPeripheral> configuredDisplays;
        private String configuredDisplaysNextLink;
        private Integer displayCount;
        private TeamworkDisplayScreenConfiguration inBuiltDisplayScreenConfiguration;
        private Boolean isContentDuplicationAllowed;
        private Boolean isDualDisplayModeEnabled;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder configuredDisplays(List<TeamworkConfiguredPeripheral> configuredDisplays) {
            this.configuredDisplays = configuredDisplays;
            this.changedFields = changedFields.add("configuredDisplays");
            return this;
        }

        public Builder configuredDisplays(TeamworkConfiguredPeripheral... configuredDisplays) {
            return configuredDisplays(Arrays.asList(configuredDisplays));
        }

        public Builder configuredDisplaysNextLink(String configuredDisplaysNextLink) {
            this.configuredDisplaysNextLink = configuredDisplaysNextLink;
            this.changedFields = changedFields.add("configuredDisplays");
            return this;
        }

        public Builder displayCount(Integer displayCount) {
            this.displayCount = displayCount;
            this.changedFields = changedFields.add("displayCount");
            return this;
        }

        public Builder inBuiltDisplayScreenConfiguration(TeamworkDisplayScreenConfiguration inBuiltDisplayScreenConfiguration) {
            this.inBuiltDisplayScreenConfiguration = inBuiltDisplayScreenConfiguration;
            this.changedFields = changedFields.add("inBuiltDisplayScreenConfiguration");
            return this;
        }

        public Builder isContentDuplicationAllowed(Boolean isContentDuplicationAllowed) {
            this.isContentDuplicationAllowed = isContentDuplicationAllowed;
            this.changedFields = changedFields.add("isContentDuplicationAllowed");
            return this;
        }

        public Builder isDualDisplayModeEnabled(Boolean isDualDisplayModeEnabled) {
            this.isDualDisplayModeEnabled = isDualDisplayModeEnabled;
            this.changedFields = changedFields.add("isDualDisplayModeEnabled");
            return this;
        }

        public TeamworkDisplayConfiguration build() {
            TeamworkDisplayConfiguration _x = new TeamworkDisplayConfiguration();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamworkDisplayConfiguration";
            _x.configuredDisplays = configuredDisplays;
            _x.configuredDisplaysNextLink = configuredDisplaysNextLink;
            _x.displayCount = displayCount;
            _x.inBuiltDisplayScreenConfiguration = inBuiltDisplayScreenConfiguration;
            _x.isContentDuplicationAllowed = isContentDuplicationAllowed;
            _x.isDualDisplayModeEnabled = isDualDisplayModeEnabled;
            return _x;
        }
    }

    private TeamworkDisplayConfiguration _copy() {
        TeamworkDisplayConfiguration _x = new TeamworkDisplayConfiguration();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.configuredDisplays = configuredDisplays;
        _x.displayCount = displayCount;
        _x.inBuiltDisplayScreenConfiguration = inBuiltDisplayScreenConfiguration;
        _x.isContentDuplicationAllowed = isContentDuplicationAllowed;
        _x.isDualDisplayModeEnabled = isDualDisplayModeEnabled;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamworkDisplayConfiguration[");
        b.append("configuredDisplays=");
        b.append(this.configuredDisplays);
        b.append(", ");
        b.append("displayCount=");
        b.append(this.displayCount);
        b.append(", ");
        b.append("inBuiltDisplayScreenConfiguration=");
        b.append(this.inBuiltDisplayScreenConfiguration);
        b.append(", ");
        b.append("isContentDuplicationAllowed=");
        b.append(this.isContentDuplicationAllowed);
        b.append(", ");
        b.append("isDualDisplayModeEnabled=");
        b.append(this.isDualDisplayModeEnabled);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
