package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "adminAgentSoftwareVersion", 
    "firmwareSoftwareVersion", 
    "operatingSystemSoftwareVersion", 
    "partnerAgentSoftwareVersion", 
    "teamsClientSoftwareVersion"})
@JsonInclude(Include.NON_NULL)
public class TeamworkDeviceSoftwareVersions implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("adminAgentSoftwareVersion")
    protected String adminAgentSoftwareVersion;

    @JsonProperty("firmwareSoftwareVersion")
    protected String firmwareSoftwareVersion;

    @JsonProperty("operatingSystemSoftwareVersion")
    protected String operatingSystemSoftwareVersion;

    @JsonProperty("partnerAgentSoftwareVersion")
    protected String partnerAgentSoftwareVersion;

    @JsonProperty("teamsClientSoftwareVersion")
    protected String teamsClientSoftwareVersion;

    protected TeamworkDeviceSoftwareVersions() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamworkDeviceSoftwareVersions";
    }

    @Property(name="adminAgentSoftwareVersion")
    @JsonIgnore
    public Optional<String> getAdminAgentSoftwareVersion() {
        return Optional.ofNullable(adminAgentSoftwareVersion);
    }

    public TeamworkDeviceSoftwareVersions withAdminAgentSoftwareVersion(String adminAgentSoftwareVersion) {
        TeamworkDeviceSoftwareVersions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceSoftwareVersions");
        _x.adminAgentSoftwareVersion = adminAgentSoftwareVersion;
        return _x;
    }

    @Property(name="firmwareSoftwareVersion")
    @JsonIgnore
    public Optional<String> getFirmwareSoftwareVersion() {
        return Optional.ofNullable(firmwareSoftwareVersion);
    }

    public TeamworkDeviceSoftwareVersions withFirmwareSoftwareVersion(String firmwareSoftwareVersion) {
        TeamworkDeviceSoftwareVersions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceSoftwareVersions");
        _x.firmwareSoftwareVersion = firmwareSoftwareVersion;
        return _x;
    }

    @Property(name="operatingSystemSoftwareVersion")
    @JsonIgnore
    public Optional<String> getOperatingSystemSoftwareVersion() {
        return Optional.ofNullable(operatingSystemSoftwareVersion);
    }

    public TeamworkDeviceSoftwareVersions withOperatingSystemSoftwareVersion(String operatingSystemSoftwareVersion) {
        TeamworkDeviceSoftwareVersions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceSoftwareVersions");
        _x.operatingSystemSoftwareVersion = operatingSystemSoftwareVersion;
        return _x;
    }

    @Property(name="partnerAgentSoftwareVersion")
    @JsonIgnore
    public Optional<String> getPartnerAgentSoftwareVersion() {
        return Optional.ofNullable(partnerAgentSoftwareVersion);
    }

    public TeamworkDeviceSoftwareVersions withPartnerAgentSoftwareVersion(String partnerAgentSoftwareVersion) {
        TeamworkDeviceSoftwareVersions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceSoftwareVersions");
        _x.partnerAgentSoftwareVersion = partnerAgentSoftwareVersion;
        return _x;
    }

    @Property(name="teamsClientSoftwareVersion")
    @JsonIgnore
    public Optional<String> getTeamsClientSoftwareVersion() {
        return Optional.ofNullable(teamsClientSoftwareVersion);
    }

    public TeamworkDeviceSoftwareVersions withTeamsClientSoftwareVersion(String teamsClientSoftwareVersion) {
        TeamworkDeviceSoftwareVersions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDeviceSoftwareVersions");
        _x.teamsClientSoftwareVersion = teamsClientSoftwareVersion;
        return _x;
    }

    public TeamworkDeviceSoftwareVersions withUnmappedField(String name, Object value) {
        TeamworkDeviceSoftwareVersions _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String adminAgentSoftwareVersion;
        private String firmwareSoftwareVersion;
        private String operatingSystemSoftwareVersion;
        private String partnerAgentSoftwareVersion;
        private String teamsClientSoftwareVersion;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder adminAgentSoftwareVersion(String adminAgentSoftwareVersion) {
            this.adminAgentSoftwareVersion = adminAgentSoftwareVersion;
            this.changedFields = changedFields.add("adminAgentSoftwareVersion");
            return this;
        }

        public Builder firmwareSoftwareVersion(String firmwareSoftwareVersion) {
            this.firmwareSoftwareVersion = firmwareSoftwareVersion;
            this.changedFields = changedFields.add("firmwareSoftwareVersion");
            return this;
        }

        public Builder operatingSystemSoftwareVersion(String operatingSystemSoftwareVersion) {
            this.operatingSystemSoftwareVersion = operatingSystemSoftwareVersion;
            this.changedFields = changedFields.add("operatingSystemSoftwareVersion");
            return this;
        }

        public Builder partnerAgentSoftwareVersion(String partnerAgentSoftwareVersion) {
            this.partnerAgentSoftwareVersion = partnerAgentSoftwareVersion;
            this.changedFields = changedFields.add("partnerAgentSoftwareVersion");
            return this;
        }

        public Builder teamsClientSoftwareVersion(String teamsClientSoftwareVersion) {
            this.teamsClientSoftwareVersion = teamsClientSoftwareVersion;
            this.changedFields = changedFields.add("teamsClientSoftwareVersion");
            return this;
        }

        public TeamworkDeviceSoftwareVersions build() {
            TeamworkDeviceSoftwareVersions _x = new TeamworkDeviceSoftwareVersions();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamworkDeviceSoftwareVersions";
            _x.adminAgentSoftwareVersion = adminAgentSoftwareVersion;
            _x.firmwareSoftwareVersion = firmwareSoftwareVersion;
            _x.operatingSystemSoftwareVersion = operatingSystemSoftwareVersion;
            _x.partnerAgentSoftwareVersion = partnerAgentSoftwareVersion;
            _x.teamsClientSoftwareVersion = teamsClientSoftwareVersion;
            return _x;
        }
    }

    private TeamworkDeviceSoftwareVersions _copy() {
        TeamworkDeviceSoftwareVersions _x = new TeamworkDeviceSoftwareVersions();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.adminAgentSoftwareVersion = adminAgentSoftwareVersion;
        _x.firmwareSoftwareVersion = firmwareSoftwareVersion;
        _x.operatingSystemSoftwareVersion = operatingSystemSoftwareVersion;
        _x.partnerAgentSoftwareVersion = partnerAgentSoftwareVersion;
        _x.teamsClientSoftwareVersion = teamsClientSoftwareVersion;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamworkDeviceSoftwareVersions[");
        b.append("adminAgentSoftwareVersion=");
        b.append(this.adminAgentSoftwareVersion);
        b.append(", ");
        b.append("firmwareSoftwareVersion=");
        b.append(this.firmwareSoftwareVersion);
        b.append(", ");
        b.append("operatingSystemSoftwareVersion=");
        b.append(this.operatingSystemSoftwareVersion);
        b.append(", ");
        b.append("partnerAgentSoftwareVersion=");
        b.append(this.partnerAgentSoftwareVersion);
        b.append(", ");
        b.append("teamsClientSoftwareVersion=");
        b.append(this.teamsClientSoftwareVersion);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
