package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.LocalTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "dateFormat", 
    "officeHoursEndTime", 
    "officeHoursStartTime", 
    "timeFormat", 
    "timeZone"})
@JsonInclude(Include.NON_NULL)
public class TeamworkDateTimeConfiguration implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("dateFormat")
    protected String dateFormat;

    @JsonProperty("officeHoursEndTime")
    protected LocalTime officeHoursEndTime;

    @JsonProperty("officeHoursStartTime")
    protected LocalTime officeHoursStartTime;

    @JsonProperty("timeFormat")
    protected String timeFormat;

    @JsonProperty("timeZone")
    protected String timeZone;

    protected TeamworkDateTimeConfiguration() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamworkDateTimeConfiguration";
    }

    @Property(name="dateFormat")
    @JsonIgnore
    public Optional<String> getDateFormat() {
        return Optional.ofNullable(dateFormat);
    }

    public TeamworkDateTimeConfiguration withDateFormat(String dateFormat) {
        TeamworkDateTimeConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDateTimeConfiguration");
        _x.dateFormat = dateFormat;
        return _x;
    }

    @Property(name="officeHoursEndTime")
    @JsonIgnore
    public Optional<LocalTime> getOfficeHoursEndTime() {
        return Optional.ofNullable(officeHoursEndTime);
    }

    public TeamworkDateTimeConfiguration withOfficeHoursEndTime(LocalTime officeHoursEndTime) {
        TeamworkDateTimeConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDateTimeConfiguration");
        _x.officeHoursEndTime = officeHoursEndTime;
        return _x;
    }

    @Property(name="officeHoursStartTime")
    @JsonIgnore
    public Optional<LocalTime> getOfficeHoursStartTime() {
        return Optional.ofNullable(officeHoursStartTime);
    }

    public TeamworkDateTimeConfiguration withOfficeHoursStartTime(LocalTime officeHoursStartTime) {
        TeamworkDateTimeConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDateTimeConfiguration");
        _x.officeHoursStartTime = officeHoursStartTime;
        return _x;
    }

    @Property(name="timeFormat")
    @JsonIgnore
    public Optional<String> getTimeFormat() {
        return Optional.ofNullable(timeFormat);
    }

    public TeamworkDateTimeConfiguration withTimeFormat(String timeFormat) {
        TeamworkDateTimeConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDateTimeConfiguration");
        _x.timeFormat = timeFormat;
        return _x;
    }

    @Property(name="timeZone")
    @JsonIgnore
    public Optional<String> getTimeZone() {
        return Optional.ofNullable(timeZone);
    }

    public TeamworkDateTimeConfiguration withTimeZone(String timeZone) {
        TeamworkDateTimeConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkDateTimeConfiguration");
        _x.timeZone = timeZone;
        return _x;
    }

    public TeamworkDateTimeConfiguration withUnmappedField(String name, Object value) {
        TeamworkDateTimeConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String dateFormat;
        private LocalTime officeHoursEndTime;
        private LocalTime officeHoursStartTime;
        private String timeFormat;
        private String timeZone;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder dateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            this.changedFields = changedFields.add("dateFormat");
            return this;
        }

        public Builder officeHoursEndTime(LocalTime officeHoursEndTime) {
            this.officeHoursEndTime = officeHoursEndTime;
            this.changedFields = changedFields.add("officeHoursEndTime");
            return this;
        }

        public Builder officeHoursStartTime(LocalTime officeHoursStartTime) {
            this.officeHoursStartTime = officeHoursStartTime;
            this.changedFields = changedFields.add("officeHoursStartTime");
            return this;
        }

        public Builder timeFormat(String timeFormat) {
            this.timeFormat = timeFormat;
            this.changedFields = changedFields.add("timeFormat");
            return this;
        }

        public Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            this.changedFields = changedFields.add("timeZone");
            return this;
        }

        public TeamworkDateTimeConfiguration build() {
            TeamworkDateTimeConfiguration _x = new TeamworkDateTimeConfiguration();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamworkDateTimeConfiguration";
            _x.dateFormat = dateFormat;
            _x.officeHoursEndTime = officeHoursEndTime;
            _x.officeHoursStartTime = officeHoursStartTime;
            _x.timeFormat = timeFormat;
            _x.timeZone = timeZone;
            return _x;
        }
    }

    private TeamworkDateTimeConfiguration _copy() {
        TeamworkDateTimeConfiguration _x = new TeamworkDateTimeConfiguration();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.dateFormat = dateFormat;
        _x.officeHoursEndTime = officeHoursEndTime;
        _x.officeHoursStartTime = officeHoursStartTime;
        _x.timeFormat = timeFormat;
        _x.timeZone = timeZone;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamworkDateTimeConfiguration[");
        b.append("dateFormat=");
        b.append(this.dateFormat);
        b.append(", ");
        b.append("officeHoursEndTime=");
        b.append(this.officeHoursEndTime);
        b.append(", ");
        b.append("officeHoursStartTime=");
        b.append(this.officeHoursStartTime);
        b.append(", ");
        b.append("timeFormat=");
        b.append(this.timeFormat);
        b.append(", ");
        b.append("timeZone=");
        b.append(this.timeZone);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
