package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.TeamworkConversationIdentityType;

@JsonPropertyOrder({
    "@odata.type", 
    "conversationIdentityType"})
@JsonInclude(Include.NON_NULL)
public class TeamworkConversationIdentity extends Identity implements ODataType {

    @JsonProperty("conversationIdentityType")
    protected TeamworkConversationIdentityType conversationIdentityType;

    protected TeamworkConversationIdentity() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamworkConversationIdentity";
    }

    @Property(name="conversationIdentityType")
    @JsonIgnore
    public Optional<TeamworkConversationIdentityType> getConversationIdentityType() {
        return Optional.ofNullable(conversationIdentityType);
    }

    public TeamworkConversationIdentity withConversationIdentityType(TeamworkConversationIdentityType conversationIdentityType) {
        TeamworkConversationIdentity _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamworkConversationIdentity");
        _x.conversationIdentityType = conversationIdentityType;
        return _x;
    }

    public TeamworkConversationIdentity withUnmappedField(String name, Object value) {
        TeamworkConversationIdentity _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTeamworkConversationIdentity() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private String id;
        private TeamworkConversationIdentityType conversationIdentityType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder conversationIdentityType(TeamworkConversationIdentityType conversationIdentityType) {
            this.conversationIdentityType = conversationIdentityType;
            this.changedFields = changedFields.add("conversationIdentityType");
            return this;
        }

        public TeamworkConversationIdentity build() {
            TeamworkConversationIdentity _x = new TeamworkConversationIdentity();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.teamworkConversationIdentity";
            _x.displayName = displayName;
            _x.id = id;
            _x.conversationIdentityType = conversationIdentityType;
            return _x;
        }
    }

    private TeamworkConversationIdentity _copy() {
        TeamworkConversationIdentity _x = new TeamworkConversationIdentity();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.id = id;
        _x.conversationIdentityType = conversationIdentityType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamworkConversationIdentity[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("conversationIdentityType=");
        b.append(this.conversationIdentityType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
