package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "platformTypes"})
@JsonInclude(Include.NON_NULL)
public class TargetPolicyEndpoints implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("platformTypes")
    protected List<String> platformTypes;

    @JsonProperty("platformTypes@nextLink")
    protected String platformTypesNextLink;

    protected TargetPolicyEndpoints() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.targetPolicyEndpoints";
    }

    @Property(name="platformTypes")
    @JsonIgnore
    public CollectionPage<String> getPlatformTypes() {
        return new CollectionPage<String>(contextPath, String.class, this.platformTypes, Optional.ofNullable(platformTypesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="platformTypes")
    @JsonIgnore
    public CollectionPage<String> getPlatformTypes(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.platformTypes, Optional.ofNullable(platformTypesNextLink), Collections.emptyList(), options);
    }

    public TargetPolicyEndpoints withUnmappedField(String name, Object value) {
        TargetPolicyEndpoints _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> platformTypes;
        private String platformTypesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder platformTypes(List<String> platformTypes) {
            this.platformTypes = platformTypes;
            this.changedFields = changedFields.add("platformTypes");
            return this;
        }

        public Builder platformTypes(String... platformTypes) {
            return platformTypes(Arrays.asList(platformTypes));
        }

        public Builder platformTypesNextLink(String platformTypesNextLink) {
            this.platformTypesNextLink = platformTypesNextLink;
            this.changedFields = changedFields.add("platformTypes");
            return this;
        }

        public TargetPolicyEndpoints build() {
            TargetPolicyEndpoints _x = new TargetPolicyEndpoints();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.targetPolicyEndpoints";
            _x.platformTypes = platformTypes;
            _x.platformTypesNextLink = platformTypesNextLink;
            return _x;
        }
    }

    private TargetPolicyEndpoints _copy() {
        TargetPolicyEndpoints _x = new TargetPolicyEndpoints();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.platformTypes = platformTypes;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TargetPolicyEndpoints[");
        b.append("platformTypes=");
        b.append(this.platformTypes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
