package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "editable", 
    "id", 
    "metadata", 
    "name", 
    "objectMappings", 
    "priority", 
    "sourceDirectoryName", 
    "targetDirectoryName"})
@JsonInclude(Include.NON_NULL)
public class SynchronizationRule implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("editable")
    protected Boolean editable;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("metadata")
    protected List<StringKeyStringValuePair> metadata;

    @JsonProperty("metadata@nextLink")
    protected String metadataNextLink;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("objectMappings")
    protected List<ObjectMapping> objectMappings;

    @JsonProperty("objectMappings@nextLink")
    protected String objectMappingsNextLink;

    @JsonProperty("priority")
    protected Integer priority;

    @JsonProperty("sourceDirectoryName")
    protected String sourceDirectoryName;

    @JsonProperty("targetDirectoryName")
    protected String targetDirectoryName;

    protected SynchronizationRule() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.synchronizationRule";
    }

    @Property(name="editable")
    @JsonIgnore
    public Optional<Boolean> getEditable() {
        return Optional.ofNullable(editable);
    }

    public SynchronizationRule withEditable(Boolean editable) {
        SynchronizationRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationRule");
        _x.editable = editable;
        return _x;
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public SynchronizationRule withId(String id) {
        SynchronizationRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationRule");
        _x.id = id;
        return _x;
    }

    @Property(name="metadata")
    @JsonIgnore
    public CollectionPage<StringKeyStringValuePair> getMetadata() {
        return new CollectionPage<StringKeyStringValuePair>(contextPath, StringKeyStringValuePair.class, this.metadata, Optional.ofNullable(metadataNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="metadata")
    @JsonIgnore
    public CollectionPage<StringKeyStringValuePair> getMetadata(HttpRequestOptions options) {
        return new CollectionPage<StringKeyStringValuePair>(contextPath, StringKeyStringValuePair.class, this.metadata, Optional.ofNullable(metadataNextLink), Collections.emptyList(), options);
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public SynchronizationRule withName(String name) {
        SynchronizationRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationRule");
        _x.name = name;
        return _x;
    }

    @Property(name="objectMappings")
    @JsonIgnore
    public CollectionPage<ObjectMapping> getObjectMappings() {
        return new CollectionPage<ObjectMapping>(contextPath, ObjectMapping.class, this.objectMappings, Optional.ofNullable(objectMappingsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="objectMappings")
    @JsonIgnore
    public CollectionPage<ObjectMapping> getObjectMappings(HttpRequestOptions options) {
        return new CollectionPage<ObjectMapping>(contextPath, ObjectMapping.class, this.objectMappings, Optional.ofNullable(objectMappingsNextLink), Collections.emptyList(), options);
    }

    @Property(name="priority")
    @JsonIgnore
    public Optional<Integer> getPriority() {
        return Optional.ofNullable(priority);
    }

    public SynchronizationRule withPriority(Integer priority) {
        SynchronizationRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationRule");
        _x.priority = priority;
        return _x;
    }

    @Property(name="sourceDirectoryName")
    @JsonIgnore
    public Optional<String> getSourceDirectoryName() {
        return Optional.ofNullable(sourceDirectoryName);
    }

    public SynchronizationRule withSourceDirectoryName(String sourceDirectoryName) {
        SynchronizationRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationRule");
        _x.sourceDirectoryName = sourceDirectoryName;
        return _x;
    }

    @Property(name="targetDirectoryName")
    @JsonIgnore
    public Optional<String> getTargetDirectoryName() {
        return Optional.ofNullable(targetDirectoryName);
    }

    public SynchronizationRule withTargetDirectoryName(String targetDirectoryName) {
        SynchronizationRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationRule");
        _x.targetDirectoryName = targetDirectoryName;
        return _x;
    }

    public SynchronizationRule withUnmappedField(String name, Object value) {
        SynchronizationRule _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean editable;
        private String id;
        private List<StringKeyStringValuePair> metadata;
        private String metadataNextLink;
        private String name;
        private List<ObjectMapping> objectMappings;
        private String objectMappingsNextLink;
        private Integer priority;
        private String sourceDirectoryName;
        private String targetDirectoryName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder editable(Boolean editable) {
            this.editable = editable;
            this.changedFields = changedFields.add("editable");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder metadata(List<StringKeyStringValuePair> metadata) {
            this.metadata = metadata;
            this.changedFields = changedFields.add("metadata");
            return this;
        }

        public Builder metadata(StringKeyStringValuePair... metadata) {
            return metadata(Arrays.asList(metadata));
        }

        public Builder metadataNextLink(String metadataNextLink) {
            this.metadataNextLink = metadataNextLink;
            this.changedFields = changedFields.add("metadata");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder objectMappings(List<ObjectMapping> objectMappings) {
            this.objectMappings = objectMappings;
            this.changedFields = changedFields.add("objectMappings");
            return this;
        }

        public Builder objectMappings(ObjectMapping... objectMappings) {
            return objectMappings(Arrays.asList(objectMappings));
        }

        public Builder objectMappingsNextLink(String objectMappingsNextLink) {
            this.objectMappingsNextLink = objectMappingsNextLink;
            this.changedFields = changedFields.add("objectMappings");
            return this;
        }

        public Builder priority(Integer priority) {
            this.priority = priority;
            this.changedFields = changedFields.add("priority");
            return this;
        }

        public Builder sourceDirectoryName(String sourceDirectoryName) {
            this.sourceDirectoryName = sourceDirectoryName;
            this.changedFields = changedFields.add("sourceDirectoryName");
            return this;
        }

        public Builder targetDirectoryName(String targetDirectoryName) {
            this.targetDirectoryName = targetDirectoryName;
            this.changedFields = changedFields.add("targetDirectoryName");
            return this;
        }

        public SynchronizationRule build() {
            SynchronizationRule _x = new SynchronizationRule();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.synchronizationRule";
            _x.editable = editable;
            _x.id = id;
            _x.metadata = metadata;
            _x.metadataNextLink = metadataNextLink;
            _x.name = name;
            _x.objectMappings = objectMappings;
            _x.objectMappingsNextLink = objectMappingsNextLink;
            _x.priority = priority;
            _x.sourceDirectoryName = sourceDirectoryName;
            _x.targetDirectoryName = targetDirectoryName;
            return _x;
        }
    }

    private SynchronizationRule _copy() {
        SynchronizationRule _x = new SynchronizationRule();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.editable = editable;
        _x.id = id;
        _x.metadata = metadata;
        _x.name = name;
        _x.objectMappings = objectMappings;
        _x.priority = priority;
        _x.sourceDirectoryName = sourceDirectoryName;
        _x.targetDirectoryName = targetDirectoryName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SynchronizationRule[");
        b.append("editable=");
        b.append(this.editable);
        b.append(", ");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("metadata=");
        b.append(this.metadata);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("objectMappings=");
        b.append(this.objectMappings);
        b.append(", ");
        b.append("priority=");
        b.append(this.priority);
        b.append(", ");
        b.append("sourceDirectoryName=");
        b.append(this.sourceDirectoryName);
        b.append(", ");
        b.append("targetDirectoryName=");
        b.append(this.targetDirectoryName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
