package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "manager", 
    "members", 
    "owners"})
@JsonInclude(Include.NON_NULL)
public class SynchronizationLinkedObjects implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("manager")
    protected SynchronizationJobSubject manager;

    @JsonProperty("members")
    protected List<SynchronizationJobSubject> members;

    @JsonProperty("members@nextLink")
    protected String membersNextLink;

    @JsonProperty("owners")
    protected List<SynchronizationJobSubject> owners;

    @JsonProperty("owners@nextLink")
    protected String ownersNextLink;

    protected SynchronizationLinkedObjects() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.synchronizationLinkedObjects";
    }

    @Property(name="manager")
    @JsonIgnore
    public Optional<SynchronizationJobSubject> getManager() {
        return Optional.ofNullable(manager);
    }

    public SynchronizationLinkedObjects withManager(SynchronizationJobSubject manager) {
        SynchronizationLinkedObjects _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationLinkedObjects");
        _x.manager = manager;
        return _x;
    }

    @Property(name="members")
    @JsonIgnore
    public CollectionPage<SynchronizationJobSubject> getMembers() {
        return new CollectionPage<SynchronizationJobSubject>(contextPath, SynchronizationJobSubject.class, this.members, Optional.ofNullable(membersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="members")
    @JsonIgnore
    public CollectionPage<SynchronizationJobSubject> getMembers(HttpRequestOptions options) {
        return new CollectionPage<SynchronizationJobSubject>(contextPath, SynchronizationJobSubject.class, this.members, Optional.ofNullable(membersNextLink), Collections.emptyList(), options);
    }

    @Property(name="owners")
    @JsonIgnore
    public CollectionPage<SynchronizationJobSubject> getOwners() {
        return new CollectionPage<SynchronizationJobSubject>(contextPath, SynchronizationJobSubject.class, this.owners, Optional.ofNullable(ownersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="owners")
    @JsonIgnore
    public CollectionPage<SynchronizationJobSubject> getOwners(HttpRequestOptions options) {
        return new CollectionPage<SynchronizationJobSubject>(contextPath, SynchronizationJobSubject.class, this.owners, Optional.ofNullable(ownersNextLink), Collections.emptyList(), options);
    }

    public SynchronizationLinkedObjects withUnmappedField(String name, Object value) {
        SynchronizationLinkedObjects _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private SynchronizationJobSubject manager;
        private List<SynchronizationJobSubject> members;
        private String membersNextLink;
        private List<SynchronizationJobSubject> owners;
        private String ownersNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder manager(SynchronizationJobSubject manager) {
            this.manager = manager;
            this.changedFields = changedFields.add("manager");
            return this;
        }

        public Builder members(List<SynchronizationJobSubject> members) {
            this.members = members;
            this.changedFields = changedFields.add("members");
            return this;
        }

        public Builder members(SynchronizationJobSubject... members) {
            return members(Arrays.asList(members));
        }

        public Builder membersNextLink(String membersNextLink) {
            this.membersNextLink = membersNextLink;
            this.changedFields = changedFields.add("members");
            return this;
        }

        public Builder owners(List<SynchronizationJobSubject> owners) {
            this.owners = owners;
            this.changedFields = changedFields.add("owners");
            return this;
        }

        public Builder owners(SynchronizationJobSubject... owners) {
            return owners(Arrays.asList(owners));
        }

        public Builder ownersNextLink(String ownersNextLink) {
            this.ownersNextLink = ownersNextLink;
            this.changedFields = changedFields.add("owners");
            return this;
        }

        public SynchronizationLinkedObjects build() {
            SynchronizationLinkedObjects _x = new SynchronizationLinkedObjects();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.synchronizationLinkedObjects";
            _x.manager = manager;
            _x.members = members;
            _x.membersNextLink = membersNextLink;
            _x.owners = owners;
            _x.ownersNextLink = ownersNextLink;
            return _x;
        }
    }

    private SynchronizationLinkedObjects _copy() {
        SynchronizationLinkedObjects _x = new SynchronizationLinkedObjects();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.manager = manager;
        _x.members = members;
        _x.owners = owners;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SynchronizationLinkedObjects[");
        b.append("manager=");
        b.append(this.manager);
        b.append(", ");
        b.append("members=");
        b.append(this.members);
        b.append(", ");
        b.append("owners=");
        b.append(this.owners);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
