package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "links", 
    "objectId", 
    "objectTypeName"})
@JsonInclude(Include.NON_NULL)
public class SynchronizationJobSubject implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("links")
    protected SynchronizationLinkedObjects links;

    @JsonProperty("objectId")
    protected String objectId;

    @JsonProperty("objectTypeName")
    protected String objectTypeName;

    protected SynchronizationJobSubject() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.synchronizationJobSubject";
    }

    @Property(name="links")
    @JsonIgnore
    public Optional<SynchronizationLinkedObjects> getLinks() {
        return Optional.ofNullable(links);
    }

    public SynchronizationJobSubject withLinks(SynchronizationLinkedObjects links) {
        SynchronizationJobSubject _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationJobSubject");
        _x.links = links;
        return _x;
    }

    @Property(name="objectId")
    @JsonIgnore
    public Optional<String> getObjectId() {
        return Optional.ofNullable(objectId);
    }

    public SynchronizationJobSubject withObjectId(String objectId) {
        SynchronizationJobSubject _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationJobSubject");
        _x.objectId = objectId;
        return _x;
    }

    @Property(name="objectTypeName")
    @JsonIgnore
    public Optional<String> getObjectTypeName() {
        return Optional.ofNullable(objectTypeName);
    }

    public SynchronizationJobSubject withObjectTypeName(String objectTypeName) {
        SynchronizationJobSubject _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationJobSubject");
        _x.objectTypeName = objectTypeName;
        return _x;
    }

    public SynchronizationJobSubject withUnmappedField(String name, Object value) {
        SynchronizationJobSubject _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private SynchronizationLinkedObjects links;
        private String objectId;
        private String objectTypeName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder links(SynchronizationLinkedObjects links) {
            this.links = links;
            this.changedFields = changedFields.add("links");
            return this;
        }

        public Builder objectId(String objectId) {
            this.objectId = objectId;
            this.changedFields = changedFields.add("objectId");
            return this;
        }

        public Builder objectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
            this.changedFields = changedFields.add("objectTypeName");
            return this;
        }

        public SynchronizationJobSubject build() {
            SynchronizationJobSubject _x = new SynchronizationJobSubject();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.synchronizationJobSubject";
            _x.links = links;
            _x.objectId = objectId;
            _x.objectTypeName = objectTypeName;
            return _x;
        }
    }

    private SynchronizationJobSubject _copy() {
        SynchronizationJobSubject _x = new SynchronizationJobSubject();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.links = links;
        _x.objectId = objectId;
        _x.objectTypeName = objectTypeName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SynchronizationJobSubject[");
        b.append("links=");
        b.append(this.links);
        b.append(", ");
        b.append("objectId=");
        b.append(this.objectId);
        b.append(", ");
        b.append("objectTypeName=");
        b.append(this.objectTypeName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
