package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.SubjectRightsRequestStage;
import odata.msgraph.client.beta.enums.SubjectRightsRequestStageStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "error", 
    "stage", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class SubjectRightsRequestStageDetail implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("error")
    protected PublicError error;

    @JsonProperty("stage")
    protected SubjectRightsRequestStage stage;

    @JsonProperty("status")
    protected SubjectRightsRequestStageStatus status;

    protected SubjectRightsRequestStageDetail() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.subjectRightsRequestStageDetail";
    }

    @Property(name="error")
    @JsonIgnore
    public Optional<PublicError> getError() {
        return Optional.ofNullable(error);
    }

    public SubjectRightsRequestStageDetail withError(PublicError error) {
        SubjectRightsRequestStageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subjectRightsRequestStageDetail");
        _x.error = error;
        return _x;
    }

    @Property(name="stage")
    @JsonIgnore
    public Optional<SubjectRightsRequestStage> getStage() {
        return Optional.ofNullable(stage);
    }

    public SubjectRightsRequestStageDetail withStage(SubjectRightsRequestStage stage) {
        SubjectRightsRequestStageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subjectRightsRequestStageDetail");
        _x.stage = stage;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<SubjectRightsRequestStageStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public SubjectRightsRequestStageDetail withStatus(SubjectRightsRequestStageStatus status) {
        SubjectRightsRequestStageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subjectRightsRequestStageDetail");
        _x.status = status;
        return _x;
    }

    public SubjectRightsRequestStageDetail withUnmappedField(String name, Object value) {
        SubjectRightsRequestStageDetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private PublicError error;
        private SubjectRightsRequestStage stage;
        private SubjectRightsRequestStageStatus status;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder error(PublicError error) {
            this.error = error;
            this.changedFields = changedFields.add("error");
            return this;
        }

        public Builder stage(SubjectRightsRequestStage stage) {
            this.stage = stage;
            this.changedFields = changedFields.add("stage");
            return this;
        }

        public Builder status(SubjectRightsRequestStageStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public SubjectRightsRequestStageDetail build() {
            SubjectRightsRequestStageDetail _x = new SubjectRightsRequestStageDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.subjectRightsRequestStageDetail";
            _x.error = error;
            _x.stage = stage;
            _x.status = status;
            return _x;
        }
    }

    private SubjectRightsRequestStageDetail _copy() {
        SubjectRightsRequestStageDetail _x = new SubjectRightsRequestStageDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.error = error;
        _x.stage = stage;
        _x.status = status;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SubjectRightsRequestStageDetail[");
        b.append("error=");
        b.append(this.error);
        b.append(", ");
        b.append("stage=");
        b.append(this.stage);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
