package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.LocalTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DayOfWeek;

@JsonPropertyOrder({
    "@odata.type", 
    "dayOccurrence", 
    "dayOfWeek", 
    "month", 
    "time", 
    "year"})
@JsonInclude(Include.NON_NULL)
public class StandardTimeZoneOffset implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("dayOccurrence")
    protected Integer dayOccurrence;

    @JsonProperty("dayOfWeek")
    protected DayOfWeek dayOfWeek;

    @JsonProperty("month")
    protected Integer month;

    @JsonProperty("time")
    protected LocalTime time;

    @JsonProperty("year")
    protected Integer year;

    protected StandardTimeZoneOffset() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.standardTimeZoneOffset";
    }

    @Property(name="dayOccurrence")
    @JsonIgnore
    public Optional<Integer> getDayOccurrence() {
        return Optional.ofNullable(dayOccurrence);
    }

    public StandardTimeZoneOffset withDayOccurrence(Integer dayOccurrence) {
        StandardTimeZoneOffset _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.standardTimeZoneOffset");
        _x.dayOccurrence = dayOccurrence;
        return _x;
    }

    @Property(name="dayOfWeek")
    @JsonIgnore
    public Optional<DayOfWeek> getDayOfWeek() {
        return Optional.ofNullable(dayOfWeek);
    }

    public StandardTimeZoneOffset withDayOfWeek(DayOfWeek dayOfWeek) {
        StandardTimeZoneOffset _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.standardTimeZoneOffset");
        _x.dayOfWeek = dayOfWeek;
        return _x;
    }

    @Property(name="month")
    @JsonIgnore
    public Optional<Integer> getMonth() {
        return Optional.ofNullable(month);
    }

    public StandardTimeZoneOffset withMonth(Integer month) {
        StandardTimeZoneOffset _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.standardTimeZoneOffset");
        _x.month = month;
        return _x;
    }

    @Property(name="time")
    @JsonIgnore
    public Optional<LocalTime> getTime() {
        return Optional.ofNullable(time);
    }

    public StandardTimeZoneOffset withTime(LocalTime time) {
        StandardTimeZoneOffset _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.standardTimeZoneOffset");
        _x.time = time;
        return _x;
    }

    @Property(name="year")
    @JsonIgnore
    public Optional<Integer> getYear() {
        return Optional.ofNullable(year);
    }

    public StandardTimeZoneOffset withYear(Integer year) {
        StandardTimeZoneOffset _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.standardTimeZoneOffset");
        _x.year = year;
        return _x;
    }

    public StandardTimeZoneOffset withUnmappedField(String name, Object value) {
        StandardTimeZoneOffset _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer dayOccurrence;
        private DayOfWeek dayOfWeek;
        private Integer month;
        private LocalTime time;
        private Integer year;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder dayOccurrence(Integer dayOccurrence) {
            this.dayOccurrence = dayOccurrence;
            this.changedFields = changedFields.add("dayOccurrence");
            return this;
        }

        public Builder dayOfWeek(DayOfWeek dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            this.changedFields = changedFields.add("dayOfWeek");
            return this;
        }

        public Builder month(Integer month) {
            this.month = month;
            this.changedFields = changedFields.add("month");
            return this;
        }

        public Builder time(LocalTime time) {
            this.time = time;
            this.changedFields = changedFields.add("time");
            return this;
        }

        public Builder year(Integer year) {
            this.year = year;
            this.changedFields = changedFields.add("year");
            return this;
        }

        public StandardTimeZoneOffset build() {
            StandardTimeZoneOffset _x = new StandardTimeZoneOffset();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.standardTimeZoneOffset";
            _x.dayOccurrence = dayOccurrence;
            _x.dayOfWeek = dayOfWeek;
            _x.month = month;
            _x.time = time;
            _x.year = year;
            return _x;
        }
    }

    private StandardTimeZoneOffset _copy() {
        StandardTimeZoneOffset _x = new StandardTimeZoneOffset();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.dayOccurrence = dayOccurrence;
        _x.dayOfWeek = dayOfWeek;
        _x.month = month;
        _x.time = time;
        _x.year = year;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("StandardTimeZoneOffset[");
        b.append("dayOccurrence=");
        b.append(this.dayOccurrence);
        b.append(", ");
        b.append("dayOfWeek=");
        b.append(this.dayOfWeek);
        b.append(", ");
        b.append("month=");
        b.append(this.month);
        b.append(", ");
        b.append("time=");
        b.append(this.time);
        b.append(", ");
        b.append("year=");
        b.append(this.year);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
