package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "overview", 
    "simulationUsers"})
@JsonInclude(Include.NON_NULL)
public class SimulationReport implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("overview")
    protected SimulationReportOverview overview;

    @JsonProperty("simulationUsers")
    protected List<UserSimulationDetails> simulationUsers;

    @JsonProperty("simulationUsers@nextLink")
    protected String simulationUsersNextLink;

    protected SimulationReport() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.simulationReport";
    }

    @Property(name="overview")
    @JsonIgnore
    public Optional<SimulationReportOverview> getOverview() {
        return Optional.ofNullable(overview);
    }

    public SimulationReport withOverview(SimulationReportOverview overview) {
        SimulationReport _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulationReport");
        _x.overview = overview;
        return _x;
    }

    @Property(name="simulationUsers")
    @JsonIgnore
    public CollectionPage<UserSimulationDetails> getSimulationUsers() {
        return new CollectionPage<UserSimulationDetails>(contextPath, UserSimulationDetails.class, this.simulationUsers, Optional.ofNullable(simulationUsersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="simulationUsers")
    @JsonIgnore
    public CollectionPage<UserSimulationDetails> getSimulationUsers(HttpRequestOptions options) {
        return new CollectionPage<UserSimulationDetails>(contextPath, UserSimulationDetails.class, this.simulationUsers, Optional.ofNullable(simulationUsersNextLink), Collections.emptyList(), options);
    }

    public SimulationReport withUnmappedField(String name, Object value) {
        SimulationReport _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private SimulationReportOverview overview;
        private List<UserSimulationDetails> simulationUsers;
        private String simulationUsersNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder overview(SimulationReportOverview overview) {
            this.overview = overview;
            this.changedFields = changedFields.add("overview");
            return this;
        }

        public Builder simulationUsers(List<UserSimulationDetails> simulationUsers) {
            this.simulationUsers = simulationUsers;
            this.changedFields = changedFields.add("simulationUsers");
            return this;
        }

        public Builder simulationUsers(UserSimulationDetails... simulationUsers) {
            return simulationUsers(Arrays.asList(simulationUsers));
        }

        public Builder simulationUsersNextLink(String simulationUsersNextLink) {
            this.simulationUsersNextLink = simulationUsersNextLink;
            this.changedFields = changedFields.add("simulationUsers");
            return this;
        }

        public SimulationReport build() {
            SimulationReport _x = new SimulationReport();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.simulationReport";
            _x.overview = overview;
            _x.simulationUsers = simulationUsers;
            _x.simulationUsersNextLink = simulationUsersNextLink;
            return _x;
        }
    }

    private SimulationReport _copy() {
        SimulationReport _x = new SimulationReport();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.overview = overview;
        _x.simulationUsers = simulationUsers;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SimulationReport[");
        b.append("overview=");
        b.append(this.overview);
        b.append(", ");
        b.append("simulationUsers=");
        b.append(this.simulationUsers);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
